/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import megamek.client.ui.Messages;
import megamek.common.preference.PreferenceManager;

public class ConnectDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 5895056240077042429L;
    public String playerName;
    public String serverAddr;
    public int port;
    private JLabel yourNameL = new JLabel(Messages.getString("MegaMek.yourNameL"), 4);
    private JLabel serverAddrL = new JLabel(Messages.getString("MegaMek.serverAddrL"), 4);
    private JLabel portL = new JLabel(Messages.getString("MegaMek.portL"), 4);
    private JTextField yourNameF = new JTextField(PreferenceManager.getClientPreferences().getLastPlayerName(), 16);
    private JTextField serverAddrF;
    private JTextField portF;
    private JButton okayB;
    private JButton cancelB;

    public ConnectDialog(JFrame jFrame) {
        super(jFrame, Messages.getString("MegaMek.ConnectDialog.title"), true);
        this.yourNameF.addActionListener(this);
        this.serverAddrF = new JTextField(PreferenceManager.getClientPreferences().getLastConnectAddr(), 16);
        this.serverAddrF.addActionListener(this);
        this.portF = new JTextField(PreferenceManager.getClientPreferences().getLastConnectPort() + "", 4);
        this.portF.addActionListener(this);
        this.okayB = new JButton(Messages.getString("Okay"));
        this.okayB.setActionCommand("done");
        this.okayB.addActionListener(this);
        this.okayB.setSize(80, 24);
        this.cancelB = new JButton(Messages.getString("Cancel"));
        this.cancelB.setActionCommand("cancel");
        this.cancelB.addActionListener(this);
        this.cancelB.setSize(80, 24);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.yourNameL, gridBagConstraints);
        this.getContentPane().add(this.yourNameL);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.yourNameF, gridBagConstraints);
        this.getContentPane().add(this.yourNameF);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.serverAddrL, gridBagConstraints);
        this.getContentPane().add(this.serverAddrL);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.serverAddrF, gridBagConstraints);
        this.getContentPane().add(this.serverAddrF);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.portL, gridBagConstraints);
        this.getContentPane().add(this.portL);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.portF, gridBagConstraints);
        this.getContentPane().add(this.portF);
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.okayB, gridBagConstraints);
        this.getContentPane().add(this.okayB);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.cancelB, gridBagConstraints);
        this.getContentPane().add(this.cancelB);
        this.pack();
        this.setResizable(false);
        this.setLocation(jFrame.getLocation().x + jFrame.getSize().width / 2 - this.getSize().width / 2, jFrame.getLocation().y + jFrame.getSize().height / 2 - this.getSize().height / 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!"cancel".equals(actionEvent.getActionCommand())) {
            try {
                this.playerName = this.yourNameF.getText();
                this.serverAddr = this.serverAddrF.getText();
                this.port = Integer.decode(this.portF.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException.getMessage());
            }
            PreferenceManager.getClientPreferences().setLastPlayerName(this.playerName);
            PreferenceManager.getClientPreferences().setLastConnectAddr(this.serverAddr);
            PreferenceManager.getClientPreferences().setLastConnectPort(this.port);
        }
        this.setVisible(false);
    }
}

