/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.Building;
import megamek.common.Coords;
import megamek.common.IBoard;
import megamek.common.IHex;
import megamek.common.Targetable;

public class BuildingTarget
implements Targetable {
    private static final long serialVersionUID = 6432766092407639630L;
    private Coords position = null;
    private boolean isIgnite = false;
    private int id = -1;
    private int height = -1;
    private int elevation = -1;
    private String name = null;

    protected void init(Coords coords, IBoard iBoard, boolean bl) {
        this.position = coords;
        this.isIgnite = bl;
        Building building = iBoard.getBuildingAt(this.position);
        if (building == null) {
            throw new IllegalArgumentException("The coordinates, " + this.position.getBoardNum() + ", do not contain a building.");
        }
        this.id = BuildingTarget.coordsToId(coords);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Hex ").append(this.position.getBoardNum()).append(" of ").append(building.getName());
        if (this.isIgnite) {
            stringBuffer.append(" (Ignite)");
        } else {
            stringBuffer.append(" (Collapse)");
        }
        this.name = stringBuffer.toString();
        IHex iHex = iBoard.getHex(this.position);
        this.elevation = Math.max(-iHex.depth(), iHex.terrainLevel(28));
        this.height = iHex.terrainLevel(24);
        this.height = this.height <= 0 ? 0 : --this.height;
    }

    public BuildingTarget(Coords coords, IBoard iBoard, int n) {
        boolean bl = n == 4;
        this.init(coords, iBoard, bl);
    }

    public BuildingTarget(Coords coords, IBoard iBoard, boolean bl) {
        this.init(coords, iBoard, bl);
    }

    public int getTargetType() {
        int n = 3;
        if (this.isIgnite) {
            n = 4;
        }
        return n;
    }

    public int getTargetId() {
        return this.id;
    }

    public Coords getPosition() {
        return this.position;
    }

    public int absHeight() {
        return this.getHeight() + this.getElevation();
    }

    public int getHeight() {
        return this.height;
    }

    public int getElevation() {
        return this.elevation;
    }

    public boolean isImmobile() {
        return true;
    }

    public String getDisplayName() {
        return this.name;
    }

    public static int coordsToId(Coords coords) {
        return coords.y * 100000 + coords.x;
    }

    public static Coords idToCoords(int n) {
        int n2 = n / 100000;
        return new Coords(n - n2 * 100000, n2);
    }

    public int sideTable(Coords coords) {
        return 0;
    }

    public boolean isOffBoard() {
        return false;
    }
}

