/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Enumeration;
import java.util.Vector;
import megamek.common.TurnOrdered;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TurnVectors
implements Enumeration<TurnOrdered> {
    private final int numEven;
    private final int numNormal;
    private final int numTotal;
    private final int numSS;
    private final int numJS;
    private final int numWS;
    private final int numDS;
    private final int numSC;
    private final Vector<TurnOrdered> even_turns;
    private final Vector<TurnOrdered> normal_turns;
    private final Vector<TurnOrdered> total_turns;
    private final Vector<TurnOrdered> space_station_turns;
    private final Vector<TurnOrdered> jumpship_turns;
    private final Vector<TurnOrdered> warship_turns;
    private final Vector<TurnOrdered> dropship_turns;
    private final Vector<TurnOrdered> small_craft_turns;
    private Enumeration<TurnOrdered> turnNormalEnum = null;
    private Enumeration<TurnOrdered> evenEnum = null;
    private Enumeration<TurnOrdered> turnTotalEnum = null;
    private Enumeration<TurnOrdered> turnSSEnum = null;
    private Enumeration<TurnOrdered> turnJSEnum = null;
    private Enumeration<TurnOrdered> turnWSEnum = null;
    private Enumeration<TurnOrdered> turnDSEnum = null;
    private Enumeration<TurnOrdered> turnSCEnum = null;
    private final int min;

    private synchronized Enumeration<TurnOrdered> getTurnNormalEnum() {
        if (null == this.turnNormalEnum) {
            this.turnNormalEnum = this.normal_turns.elements();
        }
        return this.turnNormalEnum;
    }

    private synchronized Enumeration<TurnOrdered> getTurnTotalEnum() {
        if (null == this.turnTotalEnum) {
            this.turnTotalEnum = this.total_turns.elements();
        }
        return this.turnTotalEnum;
    }

    private synchronized Enumeration<TurnOrdered> getTurnSSEnum() {
        if (null == this.turnSSEnum) {
            this.turnSSEnum = this.space_station_turns.elements();
        }
        return this.turnSSEnum;
    }

    private synchronized Enumeration<TurnOrdered> getTurnJSEnum() {
        if (null == this.turnJSEnum) {
            this.turnJSEnum = this.jumpship_turns.elements();
        }
        return this.turnJSEnum;
    }

    private synchronized Enumeration<TurnOrdered> getTurnWSEnum() {
        if (null == this.turnWSEnum) {
            this.turnWSEnum = this.warship_turns.elements();
        }
        return this.turnWSEnum;
    }

    private synchronized Enumeration<TurnOrdered> getTurnDSEnum() {
        if (null == this.turnDSEnum) {
            this.turnDSEnum = this.dropship_turns.elements();
        }
        return this.turnDSEnum;
    }

    private synchronized Enumeration<TurnOrdered> getTurnSCEnum() {
        if (null == this.turnSCEnum) {
            this.turnSCEnum = this.small_craft_turns.elements();
        }
        return this.turnSCEnum;
    }

    private synchronized Enumeration<TurnOrdered> getEvenEnum() {
        if (null == this.evenEnum) {
            this.evenEnum = this.even_turns.elements();
        }
        return this.evenEnum;
    }

    public TurnVectors(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.numEven = n8;
        this.numNormal = n;
        this.numTotal = n2;
        this.numSS = n3;
        this.numJS = n4;
        this.numWS = n5;
        this.numDS = n6;
        this.numSC = n7;
        this.normal_turns = new Vector(n);
        this.total_turns = new Vector(this.numTotal);
        this.even_turns = new Vector(n8);
        this.space_station_turns = new Vector(n3);
        this.jumpship_turns = new Vector(n4);
        this.warship_turns = new Vector(n5);
        this.dropship_turns = new Vector(n6);
        this.small_craft_turns = new Vector(n7);
        this.min = n9;
    }

    public int getEvenTurns() {
        return this.even_turns.size();
    }

    public int getTotalTurns() {
        return this.total_turns.size();
    }

    public int getNormalTurns() {
        return this.normal_turns.size();
    }

    public int getSpaceStationTurns() {
        return this.space_station_turns.size();
    }

    public int getJumpshipTurns() {
        return this.jumpship_turns.size();
    }

    public int getWarshipTurns() {
        return this.warship_turns.size();
    }

    public int getDropshipTurns() {
        return this.dropship_turns.size();
    }

    public int getSmallCraftTurns() {
        return this.small_craft_turns.size();
    }

    public void addEven(TurnOrdered turnOrdered) {
        if (this.numEven == this.even_turns.size()) {
            throw new IllegalStateException("Have already added " + this.numEven + " even turns.");
        }
        this.even_turns.addElement(turnOrdered);
    }

    public void addNormal(TurnOrdered turnOrdered) {
        if (this.numNormal == this.normal_turns.size()) {
            throw new IllegalStateException("Have already added " + this.numNormal + " normal turns.");
        }
        this.normal_turns.addElement(turnOrdered);
        this.total_turns.addElement(turnOrdered);
    }

    public void addSpaceStation(TurnOrdered turnOrdered) {
        if (this.numSS == this.space_station_turns.size()) {
            throw new IllegalStateException("Have already added " + this.numSS + " space station turns.");
        }
        this.space_station_turns.addElement(turnOrdered);
        this.total_turns.addElement(turnOrdered);
    }

    public void addWarship(TurnOrdered turnOrdered) {
        if (this.numWS == this.warship_turns.size()) {
            throw new IllegalStateException("Have already added " + this.numWS + " warship turns.");
        }
        this.warship_turns.addElement(turnOrdered);
        this.total_turns.addElement(turnOrdered);
    }

    public void addJumpship(TurnOrdered turnOrdered) {
        if (this.numJS == this.jumpship_turns.size()) {
            throw new IllegalStateException("Have already added " + this.numJS + " jumpship turns.");
        }
        this.jumpship_turns.addElement(turnOrdered);
        this.total_turns.addElement(turnOrdered);
    }

    public void addDropship(TurnOrdered turnOrdered) {
        if (this.numDS == this.dropship_turns.size()) {
            throw new IllegalStateException("Have already added " + this.numDS + " dropship turns.");
        }
        this.dropship_turns.addElement(turnOrdered);
        this.total_turns.addElement(turnOrdered);
    }

    public void addSmallCraft(TurnOrdered turnOrdered) {
        if (this.numSC == this.small_craft_turns.size()) {
            throw new IllegalStateException("Have already added " + this.numSC + " small craft turns.");
        }
        this.small_craft_turns.addElement(turnOrdered);
        this.total_turns.addElement(turnOrdered);
    }

    public boolean hasMoreNormalElements() {
        return this.getTurnNormalEnum().hasMoreElements();
    }

    public TurnOrdered nextNormalElement() {
        return this.getTurnNormalEnum().nextElement();
    }

    public boolean hasMoreEvenElements() {
        return this.getEvenEnum().hasMoreElements();
    }

    @Override
    public TurnOrdered nextElement() {
        return this.getTurnTotalEnum().nextElement();
    }

    @Override
    public boolean hasMoreElements() {
        return this.getTurnTotalEnum().hasMoreElements();
    }

    public TurnOrdered nextSpaceStationElement() {
        return this.getTurnSSEnum().nextElement();
    }

    public boolean hasMoreSpaceStationElements() {
        return this.getTurnSSEnum().hasMoreElements();
    }

    public TurnOrdered nextJumpshipElement() {
        return this.getTurnJSEnum().nextElement();
    }

    public boolean hasMoreJumpshipElements() {
        return this.getTurnJSEnum().hasMoreElements();
    }

    public TurnOrdered nextWarshipElement() {
        return this.getTurnWSEnum().nextElement();
    }

    public boolean hasMoreWarshipElements() {
        return this.getTurnWSEnum().hasMoreElements();
    }

    public TurnOrdered nextDropshipElement() {
        return this.getTurnDSEnum().nextElement();
    }

    public boolean hasMoreDropshipElements() {
        return this.getTurnDSEnum().hasMoreElements();
    }

    public TurnOrdered nextSmallCraftElement() {
        return this.getTurnSCEnum().nextElement();
    }

    public boolean hasMoreSmallCraftElements() {
        return this.getTurnSCEnum().hasMoreElements();
    }

    public TurnOrdered nextEvenElement() {
        return this.getEvenEnum().nextElement();
    }

    public int getMin() {
        return this.min;
    }
}

