/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.manager;

import java.io.File;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import jrm.profile.manager.Dir;

public class DirNode
extends DefaultMutableTreeNode {
    private Dir dir;

    public DirNode(File root) {
        super(new Dir(root, "/"), true);
        this.buildDirTree(this.setDir((Dir)this.getUserObject()), this);
    }

    public DirNode(Dir dir) {
        super(dir);
        this.setDir(dir);
    }

    private void buildDirTree(Dir dir, DefaultMutableTreeNode node) {
        for (File file : dir.getFile().listFiles()) {
            if (!file.isDirectory()) continue;
            DirNode newdir = new DirNode(new Dir(file));
            node.add(newdir);
            this.buildDirTree(new Dir(file), newdir);
        }
    }

    public void reload() {
        this.removeAllChildren();
        this.buildDirTree(this.getDir(), this);
    }

    public DirNode find(File file) {
        return DirNode.find(this, file);
    }

    public static DirNode find(DirNode root, File file) {
        File parent;
        File file2 = parent = file.isFile() ? file.getParentFile() : file;
        if (parent != null) {
            Enumeration<TreeNode> e = root.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                DirNode node = (DirNode)e.nextElement();
                if (!((Dir)node.getUserObject()).getFile().equals(parent)) continue;
                return node;
            }
            return DirNode.find(root, parent.getParentFile());
        }
        return null;
    }

    public Dir getDir() {
        return this.dir;
    }

    public Dir setDir(Dir dir) {
        this.dir = dir;
        return dir;
    }
}

