/////////////////////////////////////////////////////////////////////////////

#include "headers.h"

#include "wav.h"

/////////////////////////////////////////////////////////////////////////////

FILE *wav_create(const char *filename, int chans, int samplerate) {
  /* .WAV file header */
  unsigned char wavhdr[0x2C]={
    0x52,0x49,0x46,0x46,0x00,0x00,0x00,0x00,0x57,0x41,0x56,0x45,0x66,0x6D,0x74,0x20,
    0x10,0x00,0x00,0x00,0x01,0x00,0x02,0x00,0x44,0xAC,0x00,0x00,0x10,0xB1,0x02,0x00,
    0x04,0x00,0x10,0x00,0x64,0x61,0x74,0x61,0x00,0x00,0x00,0x00
  };
  FILE *f = fopen(filename, "wb");
  if(!f) return NULL;
  wavhdr[0x16] = chans;
  put32lsb(wavhdr + 0x18, samplerate);
  put32lsb(wavhdr + 0x1C, 2 * chans * samplerate);
  fwrite(wavhdr, 1, sizeof(wavhdr), f);
  return f;
}

/////////////////////////////////////////////////////////////////////////////

void wav_close(FILE *f) {
  long tl = ftell(f);
  uint8 buf[4];
  fseek(f, 0x04, SEEK_SET);
  put32lsb(buf, tl - 0x08); fwrite(buf, 1, 4, f);
  fseek(f, 0x28, SEEK_SET);
  put32lsb(buf, tl - 0x2C); fwrite(buf, 1, 4, f);
  fseek(f, tl, SEEK_SET);
  fflush(f);
  fclose(f);
}

/////////////////////////////////////////////////////////////////////////////
