/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.lang;

public class CaseInsensitiveString {
    private final String string;
    private int hash = 0;

    public CaseInsensitiveString(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Cannot make a Case Insensitive String for null");
        }
        this.string = str;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CaseInsensitiveString) {
            CaseInsensitiveString cis = (CaseInsensitiveString)obj;
            return this.string == cis.string || this.string.equalsIgnoreCase(cis.string);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int length = this.string.length();
            for (int i = 0; i < length; ++i) {
                this.hash = this.hash * 29 + Character.toUpperCase(this.string.charAt(i));
            }
        }
        return this.hash;
    }

    public String toString() {
        return this.string;
    }
}

