/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.MapToList;

public abstract class AbstractMapToList<K, V>
implements MapToList<K, V> {
    private final Map<K, List<V>> mapToList;

    protected AbstractMapToList(Map<K, List<V>> mtl) {
        this.mapToList = mtl;
    }

    public void initializeListFor(K key) {
        if (this.mapToList.containsKey(key)) {
            throw new IllegalArgumentException("Cannot re-initialize key: " + key);
        }
        this.mapToList.put(key, new ArrayList());
    }

    @Override
    public void addToListFor(K key, V valueElement) {
        if (!this.containsListFor(key)) {
            this.initializeListFor(key);
        }
        this.mapToList.get(key).add(valueElement);
    }

    public void addToListFor(K key, int location, V valueElement) {
        if (!this.containsListFor(key)) {
            if (location != 0) {
                throw new IllegalArgumentException("Cannot add at location > 0 when list is not initialized");
            }
            this.initializeListFor(key);
        }
        this.mapToList.get(key).add(location, valueElement);
    }

    @Override
    public void addAllToListFor(K key, Collection<? extends V> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        if (!this.containsListFor(key)) {
            this.initializeListFor(key);
        }
        this.mapToList.get(key).addAll(values);
    }

    @Override
    public void addAllLists(MapToList<K, V> mtl) {
        for (K key : mtl.getKeySet()) {
            this.addAllToListFor(key, mtl.getListFor(key));
        }
    }

    @Override
    public boolean containsListFor(K key) {
        return this.mapToList.containsKey(key);
    }

    @Override
    public boolean containsInList(K key, V valueElement) {
        return this.containsListFor(key) && this.mapToList.get(key).contains(valueElement);
    }

    public boolean containsAnyInList(K key, Collection<V> values) {
        List<V> list = this.mapToList.get(key);
        if (list != null) {
            for (V v : values) {
                if (!list.contains(v)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int sizeOfListFor(K key) {
        List<V> list = this.mapToList.get(key);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    @Override
    public List<V> getListFor(K key) {
        List<V> list = this.mapToList.get(key);
        return list == null ? null : new ArrayList<V>(list);
    }

    @Override
    public boolean removeFromListFor(K key, V valueElement) {
        List<V> list = this.mapToList.get(key);
        if (list == null) {
            return false;
        }
        boolean removed = this.removeFromList(list, valueElement);
        if (removed && list.isEmpty()) {
            this.mapToList.remove(key);
        }
        return removed;
    }

    boolean removeFromList(List<V> list, V valueElement) {
        return list.remove(valueElement);
    }

    @Override
    public List<V> removeListFor(K key) {
        return this.mapToList.remove(key);
    }

    @Override
    public boolean isEmpty() {
        return this.mapToList.isEmpty();
    }

    @Override
    public int size() {
        return this.mapToList.size();
    }

    @Override
    public V getElementInList(K key, int index) {
        List<V> subList = this.mapToList.get(key);
        if (subList == null) {
            throw new IllegalArgumentException(key + " is not a key in this AbstractMapToList");
        }
        return subList.get(index);
    }

    @Override
    public void clear() {
        this.mapToList.clear();
    }

    public String toString() {
        return this.mapToList.toString();
    }

    @Override
    public Set<K> getKeySet() {
        Set<K> set = this.getEmptySet();
        set.addAll(this.mapToList.keySet());
        return set;
    }

    protected abstract Set<K> getEmptySet();

    public int hashCode() {
        return this.mapToList.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractMapToList && this.mapToList.equals(((AbstractMapToList)obj).mapToList);
    }
}

