/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.campaign;

import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.MapKey;
import pcgen.core.Campaign;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.MapChanges;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class OptionToken
extends AbstractNonEmptyToken<Campaign>
implements CDOMPrimaryToken<Campaign> {
    public String getTokenName() {
        return "OPTION";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, Campaign campaign, String value) {
        int equalsPos = value.indexOf("=");
        if (equalsPos < 0) {
            return new ParseResult.Fail("Invalid option line in campaign " + campaign.getKeyName() + " : " + value, context);
        }
        String optName = value.substring(0, equalsPos);
        if (optName.regionMatches(true, 0, "pcgen.options.", 0, 14)) {
            optName = optName.substring(14);
        }
        String optValue = value.substring(equalsPos + 1);
        context.getObjectContext().put((CDOMObject)campaign, MapKey.PROPERTY, (Object)optName, (Object)optValue);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Campaign campaign) {
        MapChanges changes = context.getObjectContext().getMapChanges((CDOMObject)campaign, MapKey.PROPERTY);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (String property : changes.getAdded().keySet()) {
            String value = (String)changes.getAdded().get(property);
            set.add(property + "=" + value);
        }
        return set.toArray(new String[set.size()]);
    }

    public Class<Campaign> getTokenClass() {
        return Campaign.class;
    }
}

