/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.base;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PlayerCharacter;

public final class CDOMObjectUtilities {
    public static final Comparator<Loadable> CDOM_SORTER = new Comparator<Loadable>(){

        @Override
        public int compare(Loadable cdo1, Loadable cdo2) {
            return CDOMObjectUtilities.compareKeys(cdo1, cdo2);
        }
    };

    private CDOMObjectUtilities() {
    }

    public static String joinKeyName(Collection<? extends CDOMObject> cdoCollection, String separator) {
        if (cdoCollection == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(cdoCollection.size() * 10);
        boolean needjoin = false;
        for (CDOMObject cDOMObject : cdoCollection) {
            if (needjoin) {
                result.append(separator);
            }
            needjoin = true;
            result.append(cDOMObject.getLSTformat());
        }
        return result.toString();
    }

    public static int compareKeys(Loadable cdo1, Loadable cdo2) {
        String base = cdo1.getKeyName();
        if (base == null) {
            if (cdo2.getKeyName() == null) {
                return 0;
            }
            return -1;
        }
        if (cdo2.getKeyName() == null) {
            return 1;
        }
        return base.compareTo(cdo2.getKeyName());
    }

    public static void addAdds(CDOMObject cdo, PlayerCharacter pc) {
        if (!pc.isAllowInteraction()) {
            return;
        }
        List<PersistentTransitionChoice<?>> addList = cdo.getListFor(ListKey.ADD);
        if (addList != null) {
            for (PersistentTransitionChoice<?> tc : addList) {
                CDOMObjectUtilities.driveChoice(cdo, tc, pc);
            }
        }
    }

    public static void removeAdds(CDOMObject cdo, PlayerCharacter pc) {
        if (!pc.isAllowInteraction()) {
            return;
        }
        List<PersistentTransitionChoice<?>> addList = cdo.getListFor(ListKey.ADD);
        if (addList != null) {
            for (PersistentTransitionChoice<?> tc : addList) {
                tc.remove(cdo, pc);
            }
        }
    }

    public static void checkRemovals(CDOMObject cdo, PlayerCharacter pc) {
        if (!pc.isAllowInteraction()) {
            return;
        }
        List<PersistentTransitionChoice<?>> removeList = cdo.getListFor(ListKey.REMOVE);
        if (removeList != null) {
            for (PersistentTransitionChoice<?> tc : removeList) {
                CDOMObjectUtilities.driveChoice(cdo, tc, pc);
            }
        }
    }

    public static void restoreRemovals(CDOMObject cdo, PlayerCharacter pc) {
        if (!pc.isAllowInteraction()) {
            return;
        }
        List<PersistentTransitionChoice<?>> removeList = cdo.getListFor(ListKey.REMOVE);
        if (removeList != null) {
            for (PersistentTransitionChoice<?> tc : removeList) {
                tc.remove(cdo, pc);
            }
        }
    }

    private static <T> void driveChoice(CDOMObject cdo, TransitionChoice<T> tc, PlayerCharacter pc) {
        tc.act(tc.driveChoice(pc), cdo, pc);
    }
}

