/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.base;

import java.util.Collection;
import java.util.Collections;
import pcgen.cdom.base.Categorized;
import pcgen.cdom.base.CategorizedChooser;
import pcgen.cdom.base.CategorizedClassIdentity;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseInformationUtilities;
import pcgen.cdom.base.Chooser;
import pcgen.cdom.base.ClassIdentity;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.CDOMChoiceManager;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.rules.context.LoadContext;

public class CategorizedChooseInformation<T extends Categorized<T>>
implements ChooseInformation<T> {
    private final PrimitiveChoiceSet<T> pcs;
    private final CDOMSingleRef<? extends Category<T>> category;
    private final String setName;
    private String title = null;
    private Chooser<T> choiceActor;
    private final Class<T> underlyingClass;

    public CategorizedChooseInformation(String name, CDOMSingleRef<? extends Category<T>> cat, PrimitiveChoiceSet<T> choice, Class<T> objClass) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (cat == null) {
            throw new IllegalArgumentException("Category cannot be null");
        }
        if (choice == null) {
            throw new IllegalArgumentException("PrimitiveChoiceSet cannot be null");
        }
        this.setName = name;
        this.category = cat;
        this.pcs = choice;
        this.underlyingClass = objClass;
    }

    @Override
    public void setChoiceActor(Chooser<T> actor) {
        this.choiceActor = actor;
    }

    @Override
    public String encodeChoice(T item) {
        return this.choiceActor.encodeChoice(item);
    }

    @Override
    public T decodeChoice(LoadContext context, String persistentFormat) {
        String choiceStr = persistentFormat;
        if (this.choiceActor instanceof CategorizedChooser) {
            return (T)((Categorized)((CategorizedChooser)this.choiceActor).decodeChoice(context, choiceStr, this.category.resolvesTo()));
        }
        return (T)((Categorized)this.choiceActor.decodeChoice(context, choiceStr));
    }

    @Override
    public Chooser<T> getChoiceActor() {
        return this.choiceActor;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CategorizedChooseInformation) {
            CategorizedChooseInformation other = (CategorizedChooseInformation)obj;
            if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
                return false;
            }
            return this.setName.equals(other.setName) && this.category.equals(other.category) && this.pcs.equals(other.pcs);
        }
        return false;
    }

    public int hashCode() {
        return this.setName.hashCode() + 29;
    }

    @Override
    public String getLSTformat() {
        return this.pcs.getLSTformat(false);
    }

    @Override
    public ClassIdentity<T> getClassIdentity() {
        return CategorizedClassIdentity.getInstance(this.underlyingClass, this.category.resolvesTo());
    }

    @Override
    public Collection<T> getSet(PlayerCharacter pc) {
        return Collections.unmodifiableCollection(this.pcs.getSet(pc));
    }

    @Override
    public String getName() {
        return this.setName;
    }

    public void setTitle(String choiceTitle) {
        this.title = choiceTitle;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public GroupingState getGroupingState() {
        return this.pcs.getGroupingState();
    }

    public CDOMSingleRef<? extends Category<T>> getCategory() {
        return this.category;
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, ChooseDriver owner, T item) {
        this.choiceActor.restoreChoice(pc, owner, item);
    }

    @Override
    public ChoiceManagerList<T> getChoiceManager(ChooseDriver owner, int cost) {
        return new CDOMChoiceManager(owner, this, null, cost);
    }

    @Override
    public CharSequence composeDisplay(Collection<? extends T> collection) {
        return ChooseInformationUtilities.buildEncodedString(this, collection);
    }

    @Override
    public void removeChoice(PlayerCharacter pc, ChooseDriver owner, T item) {
        this.choiceActor.removeChoice(pc, owner, item);
    }
}

