/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.content.CNAbilityFactory;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;

public class AbilityFromClassChoiceSet
implements PrimitiveChoiceSet<CNAbilitySelection> {
    private final CDOMSingleRef<PCClass> classRef;

    public AbilityFromClassChoiceSet(CDOMSingleRef<PCClass> pcc) {
        this.classRef = pcc;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return "CLASS." + this.classRef.getLSTformat(useAny);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbilityFromClassChoiceSet) {
            AbilityFromClassChoiceSet other = (AbilityFromClassChoiceSet)obj;
            return this.classRef.equals(other.classRef);
        }
        return false;
    }

    public int hashCode() {
        return this.classRef.hashCode();
    }

    @Override
    public Class<? super CNAbilitySelection> getChoiceClass() {
        return CNAbilitySelection.class;
    }

    @Override
    public Set<CNAbilitySelection> getSet(PlayerCharacter pc) {
        PCClass aClass = pc.getClassKeyed(this.classRef.resolvesTo().getKeyName());
        HashSet<CNAbilitySelection> set = new HashSet<CNAbilitySelection>();
        if (aClass != null) {
            List<Ability> abilityList = Collections.emptyList();
            if (abilityList != null) {
                for (Ability aFeat : abilityList) {
                    set.add(new CNAbilitySelection(CNAbilityFactory.getCNAbility(AbilityCategory.FEAT, Nature.VIRTUAL, aFeat)));
                }
            }
            for (int lvl = 0; lvl < pc.getLevel(aClass); ++lvl) {
                PCClassLevel pcl = pc.getActiveClassLevel(aClass, lvl);
                abilityList = Collections.emptyList();
                if (abilityList == null) continue;
                for (Ability aFeat : abilityList) {
                    set.add(new CNAbilitySelection(CNAbilityFactory.getCNAbility(AbilityCategory.FEAT, Nature.VIRTUAL, aFeat)));
                }
            }
        }
        return null;
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }
}

