/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content.fact;

import pcgen.base.util.FormatManager;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.GroupDefinition;
import pcgen.cdom.content.fact.FactGroup;
import pcgen.cdom.content.fact.FactInfo;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.rules.context.LoadContext;

public class FactGroupDefinition<T extends CDOMObject, F>
implements GroupDefinition<T> {
    private final FactInfo<T, F> def;

    public FactGroupDefinition(FactInfo<T, F> fi) {
        if (fi == null) {
            throw new IllegalArgumentException("Fact Info cannot be null");
        }
        this.def = fi;
    }

    @Override
    public String getPrimitiveName() {
        return this.def.getFactName();
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    @Override
    public Class<T> getReferenceClass() {
        return this.def.getUsableLocation();
    }

    @Override
    public FormatManager<?> getFormatManager() {
        return this.def.getFormatManager();
    }

    @Override
    public ObjectContainer<T> getPrimitive(LoadContext context, String value) {
        return new FactGroup<T, F>(context, this.def, value);
    }
}

