/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.HitDie;
import pcgen.cdom.content.Processor;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.facet.BonusCheckingFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.analysis.LevelFacet;
import pcgen.cdom.facet.base.AbstractAssociationFacet;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.ClassFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;

public class HitPointFacet
extends AbstractAssociationFacet<PCClassLevel, Integer>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);
    private ClassFacet classFacet;
    private RaceFacet raceFacet;
    private TemplateFacet templateFacet;
    private LevelFacet levelFacet;
    private BonusCheckingFacet bonusCheckingFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CharID id = dfce.getCharID();
        CDOMObject cdo = dfce.getCDOMObject();
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        if (!pc.isImporting()) {
            boolean first = true;
            for (PCClass pcClass : this.classFacet.getSet(id)) {
                Processor<HitDie> dieLock = cdo.get(ObjectKey.HITDIE);
                if (dieLock != null) {
                    for (int level = 1; level <= this.classFacet.getLevel(id, pcClass); ++level) {
                        HitDie baseHD = pcClass.getSafe(ObjectKey.LEVEL_HITDIE);
                        if (baseHD.equals(this.getLevelHitDie(id, pcClass, level))) continue;
                        this.rollHP(id, pcClass, level, first);
                        pc.setDirty(true);
                    }
                }
                first = false;
            }
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
    }

    public HitDie getLevelHitDie(CharID id, PCClass pcClass, int classLevel) {
        HitDie currDie = pcClass.getSafe(ObjectKey.LEVEL_HITDIE);
        Processor<HitDie> dieLock = ((Race)((AbstractItemFacet)this.raceFacet).get(id)).get(ObjectKey.HITDIE);
        if (dieLock != null) {
            currDie = dieLock.applyProcessor(currDie, pcClass);
        }
        for (PCTemplate template : this.templateFacet.getSet(id)) {
            Processor<HitDie> lock;
            if (template == null || (lock = template.get(ObjectKey.HITDIE)) == null) continue;
            currDie = lock.applyProcessor(currDie, pcClass);
        }
        PCClassLevel cl = this.classFacet.getClassLevel(id, pcClass, classLevel);
        if (cl != null) {
            if (cl.get(ObjectKey.DONTADD_HITDIE) != null) {
                currDie = HitDie.ZERO;
            } else {
                Processor<HitDie> lock = cl.get(ObjectKey.HITDIE);
                if (lock != null) {
                    currDie = lock.applyProcessor(currDie, pcClass);
                }
            }
        }
        return currDie;
    }

    public void rollHP(CharID id, PCClass pcc, int level, boolean first) {
        int roll = 0;
        HitDie lvlDie = this.getLevelHitDie(id, pcc, level);
        if (lvlDie == null || lvlDie.getDie() == 0) {
            roll = 0;
        } else {
            int min = 1 + (int)this.bonusCheckingFacet.getBonus(id, "HD", "MIN") + (int)this.bonusCheckingFacet.getBonus(id, "HD", "MIN;CLASS." + pcc.getKeyName());
            int max = this.getLevelHitDie(id, pcc, level).getDie() + (int)this.bonusCheckingFacet.getBonus(id, "HD", "MAX") + (int)this.bonusCheckingFacet.getBonus(id, "HD", "MAX;CLASS." + pcc.getKeyName());
            if (SettingsHandler.getGame().getHPFormula().length() == 0) {
                if (first && level == 1 && SettingsHandler.isHPMaxAtFirstLevel() && (!SettingsHandler.isHPMaxAtFirstPCClassLevelOnly() || pcc.isType("PC"))) {
                    roll = max;
                } else {
                    PlayerCharacter pc = this.trackingFacet.getPC(id);
                    if (!pc.isImporting()) {
                        roll = Globals.rollHP(min, max, pcc.getDisplayName(), level, this.levelFacet.getTotalLevels(id));
                    }
                }
            }
            roll += (int)this.bonusCheckingFacet.getBonus(id, "HP", "CURRENTMAXPERLEVEL");
        }
        PCClassLevel classLevel = this.classFacet.getClassLevel(id, pcc, level - 1);
        this.set(id, classLevel, roll);
    }

    public void setClassFacet(ClassFacet classFacet) {
        this.classFacet = classFacet;
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    public void setLevelFacet(LevelFacet levelFacet) {
        this.levelFacet = levelFacet;
    }

    public void setBonusCheckingFacet(BonusCheckingFacet bonusCheckingFacet) {
        this.bonusCheckingFacet = bonusCheckingFacet;
    }

    public void init() {
        this.templateFacet.addDataFacetChangeListener(this);
    }
}

