/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.ClassLevelFacet;
import pcgen.cdom.facet.model.DeityFacet;
import pcgen.cdom.facet.model.DomainFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.core.PlayerCharacter;

public class RemoveFacet
implements DataFacetChangeListener<CharID, CDOMObject> {
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);
    private RaceFacet raceFacet;
    private DeityFacet deityFacet;
    private TemplateFacet templateFacet;
    private DomainFacet domainFacet;
    private ClassLevelFacet classLevelFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo;
        List<PersistentTransitionChoice<?>> removeList;
        CharID id = dfce.getCharID();
        PlayerCharacter aPC = this.trackingFacet.getPC(id);
        if (!aPC.isImporting() && (removeList = (cdo = dfce.getCDOMObject()).getListFor(ListKey.REMOVE)) != null) {
            for (PersistentTransitionChoice<?> tc : removeList) {
                RemoveFacet.driveChoice(cdo, tc, aPC);
            }
        }
    }

    private static <T> void driveChoice(CDOMObject cdo, TransitionChoice<T> tc, PlayerCharacter pc) {
        tc.act(tc.driveChoice(pc), cdo, pc);
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void setDeityFacet(DeityFacet deityFacet) {
        this.deityFacet = deityFacet;
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    public void setDomainFacet(DomainFacet domainFacet) {
        this.domainFacet = domainFacet;
    }

    public void setClassLevelFacet(ClassLevelFacet classLevelFacet) {
        this.classLevelFacet = classLevelFacet;
    }

    public void init() {
        this.raceFacet.addDataFacetChangeListener(this);
        this.deityFacet.addDataFacetChangeListener(this);
        this.templateFacet.addDataFacetChangeListener(this);
        this.domainFacet.addDataFacetChangeListener(this);
        this.classLevelFacet.addDataFacetChangeListener(this);
    }
}

