/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.base;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.PCGenIdentifier;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.facet.CategorizedDataFacetChangeEvent;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;

public abstract class AbstractDataFacet<IDT extends PCGenIdentifier, T>
extends AbstractStorageFacet<IDT> {
    private final Map<Integer, DataFacetChangeListener<IDT, ? super T>[]> listeners = new TreeMap<Integer, DataFacetChangeListener<IDT, ? super T>[]>();

    public void addDataFacetChangeListener(DataFacetChangeListener<IDT, ? super T> listener) {
        this.addDataFacetChangeListener(0, listener);
    }

    public void addDataFacetChangeListener(int priority, DataFacetChangeListener<IDT, ? super T> listener) {
        DataFacetChangeListener<IDT, ? super T>[] dfcl = this.listeners.get(priority);
        int newSize = dfcl == null ? 1 : dfcl.length + 1;
        DataFacetChangeListener[] newArray = new DataFacetChangeListener[newSize];
        if (dfcl != null) {
            System.arraycopy(dfcl, 0, newArray, 1, dfcl.length);
        }
        newArray[0] = listener;
        this.listeners.put(priority, newArray);
    }

    public void removeDataFacetChangeListener(DataFacetChangeListener<IDT, ? super T> listener) {
        this.removeDataFacetChangeListener(0, listener);
    }

    public void removeDataFacetChangeListener(int priority, DataFacetChangeListener<IDT, ? super T> listener) {
        int newSize;
        DataFacetChangeListener<IDT, ? super T>[] dfcl = this.listeners.get(priority);
        if (dfcl == null) {
            return;
        }
        int foundLoc = -1;
        for (int i = newSize = dfcl.length - 1; i >= 0; --i) {
            if (dfcl[i] != listener) continue;
            foundLoc = i;
            break;
        }
        if (foundLoc != -1) {
            if (dfcl.length == 1) {
                this.listeners.remove(priority);
            } else {
                DataFacetChangeListener[] newArray = new DataFacetChangeListener[newSize];
                if (foundLoc != 0) {
                    System.arraycopy(dfcl, 0, newArray, 0, foundLoc);
                }
                if (foundLoc != newSize) {
                    System.arraycopy(dfcl, foundLoc + 1, newArray, foundLoc, newSize - foundLoc);
                }
                this.listeners.put(priority, newArray);
            }
        }
    }

    protected void fireDataFacetChangeEvent(IDT id, T node, int type) {
        this.fireDataFacetChangeEvent(id, node, type, null, null);
    }

    protected void fireDataFacetChangeEvent(IDT id, T node, int type, Category category, Nature nature) {
        for (DataFacetChangeListener<IDT, ? super T>[] dfclArray : this.listeners.values()) {
            DataFacetChangeEvent<IDT, T> ccEvent = null;
            block5: for (int i = dfclArray.length - 1; i >= 0; --i) {
                if (ccEvent == null) {
                    ccEvent = category == null ? new DataFacetChangeEvent<IDT, T>(id, node, this, type) : new CategorizedDataFacetChangeEvent<IDT, T>(id, node, this, type, category, nature);
                }
                DataFacetChangeListener<IDT, T> dfcl = dfclArray[i];
                switch (ccEvent.getEventType()) {
                    case 0: {
                        dfcl.dataAdded(ccEvent);
                        continue block5;
                    }
                    case 1: {
                        dfcl.dataRemoved(ccEvent);
                        continue block5;
                    }
                }
            }
        }
    }

    public DataFacetChangeListener<IDT, ? super T>[] getDataFacetChangeListeners() {
        ArrayList<DataFacetChangeListener<IDT, ? super T>> list = new ArrayList<DataFacetChangeListener<IDT, ? super T>>();
        for (DataFacetChangeListener<IDT, ? super T>[] dfclArray : this.listeners.values()) {
            for (DataFacetChangeListener<IDT, ? super T> listener : dfclArray) {
                list.add(listener);
            }
        }
        return list.toArray(new DataFacetChangeListener[list.size()]);
    }
}

