/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.base.UserSelection;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.AddObjectActions;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.LastGroupSeparator;

public class AbilityUtilities {
    private AbilityUtilities() {
    }

    public static void finaliseAbility(PlayerCharacter aPC, CNAbilitySelection cnas) {
        CNAbility cna = cnas.getCNAbility();
        Ability ability = cna.getAbility();
        TransitionChoice<CNAbility> mc = ability.get(ObjectKey.MODIFY_CHOICE);
        if (mc != null) {
            mc.act(mc.driveChoice(aPC), ability, aPC);
        }
        for (TransitionChoice<Kit> kit : ability.getSafeListFor(ListKey.KIT_CHOICE)) {
            kit.act(kit.driveChoice(aPC), ability, aPC);
        }
        aPC.adjustMoveRates();
        AddObjectActions.globalChecks(ability, aPC);
        aPC.calcActiveBonuses();
    }

    public static void adjustPool(Ability ability, PlayerCharacter aPC, boolean addIt) {
        double abilityCount = ability.getSafe(ObjectKey.SELECTION_COST).doubleValue();
        if (addIt) {
            abilityCount *= -1.0;
        }
        aPC.adjustAbilities(AbilityCategory.FEAT, BigDecimal.valueOf(abilityCount));
    }

    public static String removeChoicesFromName(String name) {
        LastGroupSeparator lgs = new LastGroupSeparator(name);
        lgs.process();
        return lgs.getRoot().trim();
    }

    public static String getUndecoratedName(String name, Collection<String> specifics) throws LastGroupSeparator.GroupingMismatchException {
        LastGroupSeparator lgs = new LastGroupSeparator(name);
        String subName = lgs.process();
        String altName = lgs.getRoot();
        specifics.clear();
        if (subName != null) {
            specifics.addAll(CoreUtility.split(subName, ','));
        }
        return altName.trim();
    }

    public static boolean alreadySelected(PlayerCharacter pc, Ability ability, String selection, boolean allowStack) {
        List<CNAbility> cnAbilities = pc.getMatchingCNAbilities(ability);
        if (cnAbilities.isEmpty()) {
            return false;
        }
        if (!ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            return true;
        }
        if (allowStack && ability.getSafe(ObjectKey.STACKS).booleanValue()) {
            return false;
        }
        ChooseInformation<?> info = ability.get(ObjectKey.CHOOSE_INFO);
        Object decoded = info.decodeChoice(Globals.getContext(), selection);
        for (CNAbility cna : cnAbilities) {
            List<?> oldSelections = pc.getDetailedAssociations(cna);
            if (oldSelections == null || !oldSelections.contains(decoded)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFeat(Object obj) {
        if (!(obj instanceof Ability)) {
            return false;
        }
        Ability ability = (Ability)obj;
        if (ability.getCDOMCategory() == null) {
            return false;
        }
        return ability.getCDOMCategory() == AbilityCategory.FEAT || ability.getCDOMCategory().getParentCategory() == AbilityCategory.FEAT;
    }

    public static Ability validateCNAList(List<CNAbility> list) {
        Ability a = null;
        for (CNAbility cna : list) {
            if (a == null) {
                a = cna.getAbility();
                continue;
            }
            if (cna.getAbility().getKeyName().equals(a.getKeyName()) && a.getCDOMCategory().equals(cna.getAbilityCategory().getParentCategory())) continue;
            throw new IllegalArgumentException("CNAbility list must be a consistent list of Abilities (same object)");
        }
        return a;
    }

    public static void driveChooseAndAdd(CNAbility cna, PlayerCharacter pc, boolean toAdd) {
        ArrayList<String> reservedList;
        AbilityCategory category;
        ChoiceManagerList aMan;
        Ability ability = cna.getAbility();
        if (!ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            CNAbilitySelection cnas = new CNAbilitySelection(cna);
            if (toAdd) {
                pc.addAbility(cnas, UserSelection.getInstance(), UserSelection.getInstance());
            } else {
                pc.removeAbility(cnas, UserSelection.getInstance(), UserSelection.getInstance());
            }
        }
        if ((aMan = ChooserUtilities.getConfiguredController(cna, pc, category = (AbilityCategory)cna.getAbilityCategory(), reservedList = new ArrayList<String>())) != null) {
            AbilityUtilities.processSelection(pc, cna, aMan, toAdd);
            return;
        }
    }

    private static <T> void processSelection(PlayerCharacter pc, CNAbility cna, ChoiceManagerList<T> aMan, boolean toAdd) {
        CNAbilitySelection cnas;
        String selection;
        ArrayList availableList = new ArrayList();
        ArrayList selectedList = new ArrayList();
        aMan.getChoices(pc, availableList, selectedList);
        if (availableList.size() == 0 && selectedList.size() == 0) {
            return;
        }
        ArrayList origSelections = new ArrayList(selectedList);
        ArrayList removedSelections = new ArrayList(selectedList);
        ArrayList<String> reservedList = new ArrayList<String>();
        List<T> newSelections = toAdd ? aMan.doChooser(pc, availableList, selectedList, reservedList) : aMan.doChooserRemove(pc, availableList, selectedList, reservedList);
        for (Object obj : newSelections) {
            removedSelections.remove(obj);
        }
        for (Object obj : origSelections) {
            newSelections.remove(obj);
        }
        for (Object sel : newSelections) {
            selection = aMan.encodeChoice(sel);
            cnas = new CNAbilitySelection(cna, selection);
            pc.addAbility(cnas, UserSelection.getInstance(), UserSelection.getInstance());
        }
        for (Object sel : removedSelections) {
            selection = aMan.encodeChoice(sel);
            cnas = new CNAbilitySelection(cna, selection);
            pc.removeAbility(cnas, UserSelection.getInstance(), UserSelection.getInstance());
        }
    }
}

