/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.util.Logging;

public class Movement {
    private final String[] movementTypes;
    private final double[] movements;
    private final double[] movementMult;
    private final String[] movementMultOp;
    private int moveRatesFlag;
    private int movement;

    public Movement(int i) {
        if (i <= 0) {
            throw new IllegalArgumentException("Argument of array length to ConcreteMovementconstructor must be positive");
        }
        this.movementTypes = new String[i];
        this.movements = new double[i];
        this.movementMult = new double[i];
        this.movementMultOp = new String[i];
        this.movement = 0;
    }

    public void setMoveRatesFlag(int i) {
        if (i != 0 && i != 2) {
            throw new IllegalArgumentException("Rate Flag must be 0 or 2");
        }
        this.moveRatesFlag = i;
    }

    public int getMoveRatesFlag() {
        return this.moveRatesFlag;
    }

    public Double getDoubleMovement() {
        return this.movements[this.movement];
    }

    public double getMovementMult(int index) {
        return this.movementMult[index];
    }

    public String getMovementMultOp(int index) {
        return this.movementMultOp[index];
    }

    public double[] getMovementMult() {
        return (double[])this.movementMult.clone();
    }

    public String[] getMovementMultOp() {
        return (String[])this.movementMultOp.clone();
    }

    public int getNumberOfMovementTypes() {
        return this.movementTypes.length;
    }

    public String getMovementType(int i) {
        return i < this.movementTypes.length ? this.movementTypes[i] : "";
    }

    public String[] getMovementTypes() {
        return (String[])this.movementTypes.clone();
    }

    public double getMovement(int i) {
        return i < this.movements.length ? this.movements[i] : 0.0;
    }

    public int getNumberOfMovements() {
        return this.movements.length;
    }

    public double[] getMovements() {
        return (double[])this.movements.clone();
    }

    public String toString() {
        StringBuilder movelabel = new StringBuilder();
        if (this.movementTypes.length > 0) {
            movelabel.append(this.movementTypes[0]);
            NumberFormat numFmt = NumberFormat.getNumberInstance();
            movelabel.append(' ').append(numFmt.format(Globals.getGameModeUnitSet().convertDistanceToUnitSet(this.movements[0])));
            movelabel.append(Globals.getGameModeUnitSet().getDistanceUnit());
            if (this.movementMult[0] != 0.0) {
                movelabel.append('(').append(this.movementMultOp[0]).append(numFmt.format(this.movementMult[0])).append(')');
            }
            for (int i = 1; i < this.movementTypes.length; ++i) {
                movelabel.append(", ");
                movelabel.append(this.movementTypes[i]);
                movelabel.append(' ').append(numFmt.format(Globals.getGameModeUnitSet().convertDistanceToUnitSet(this.movements[i])));
                movelabel.append(Globals.getGameModeUnitSet().getDistanceUnit());
                if (this.movementMult[i] == 0.0) continue;
                movelabel.append('(').append(this.movementMultOp[i]).append(numFmt.format(this.movementMult[i])).append(')');
            }
        }
        return movelabel.toString();
    }

    public void addTokenContents(StringBuilder txt) {
        if (this.moveRatesFlag == 2) {
            txt.append(this.movementTypes[0]);
            txt.append(',');
            txt.append(this.movementTypes[1]);
            txt.append(',');
            if (this.movementMultOp[1].length() > 0) {
                String multValue = NumberFormat.getNumberInstance().format(this.movementMult[1]);
                txt.append(this.movementMultOp[1]).append(multValue);
            } else {
                txt.append(new DecimalFormat("###0").format(this.movements[1]));
            }
            return;
        }
        for (int index = 0; index < this.movementTypes.length; ++index) {
            if (index > 0) {
                txt.append(',');
            }
            if (this.movementTypes[index] != null && this.movementTypes[index].length() > 0) {
                txt.append(this.movementTypes[index]).append(',');
            }
            if (this.movementMultOp[index].length() > 0) {
                txt.append(this.movementMultOp[index]).append(this.movementMult[index]);
                continue;
            }
            txt.append(new DecimalFormat("###0").format(this.movements[index]));
        }
    }

    public static Movement getMovementFrom(String moveparse) {
        Movement cm;
        if (moveparse == null) {
            throw new IllegalArgumentException("Null initialization String illegal");
        }
        StringTokenizer moves = new StringTokenizer(moveparse, ",");
        if (moves.countTokens() == 1) {
            cm = new Movement(1);
            cm.assignMovement(0, "Walk", moves.nextToken());
        } else {
            cm = new Movement(moves.countTokens() / 2);
            int x = 0;
            while (moves.countTokens() > 1) {
                cm.assignMovement(x++, moves.nextToken(), moves.nextToken());
            }
            if (moves.countTokens() != 0) {
                Logging.errorPrint("Badly formed MOVE token (extra value at end of list): " + moveparse);
            }
        }
        return cm;
    }

    public void assignMovement(int x, String type, String mod) {
        this.movementTypes[x] = type;
        this.movementMult[x] = 0.0;
        this.movementMultOp[x] = "";
        if (mod.length() > 0 && (mod.charAt(0) == '*' || mod.charAt(0) == '/')) {
            this.movements[x] = 0.0;
            try {
                double multValue = Double.parseDouble(mod.substring(1));
                if (multValue < 0.0) {
                    Logging.errorPrint("Illegal movement multiplier: " + multValue + " in movement string " + mod);
                }
                this.movementMult[x] = multValue;
                this.movementMultOp[x] = mod.substring(0, 1);
            }
            catch (NumberFormatException e) {
                Logging.errorPrint("Badly formed MOVE token: " + mod);
                this.movementMult[x] = 0.0;
                this.movementMultOp[x] = "";
            }
        } else if (mod.length() > 0) {
            this.movementMult[x] = 0.0;
            this.movementMultOp[x] = "";
            try {
                this.movements[x] = Double.parseDouble(mod);
            }
            catch (NumberFormatException e) {
                Logging.errorPrint("Badly formed MOVE token: " + mod);
                this.movements[x] = 0.0;
            }
            if ("Walk".equals(this.movementTypes[x])) {
                this.movement = x;
            }
        }
    }
}

