/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.list.VisionList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.core.PlayerCharacter;
import pcgen.util.enumeration.VisionType;

public class Vision
extends CDOMObject
implements Comparable<Vision> {
    public static final CDOMReference<VisionList> VISIONLIST;
    private final VisionType visionType;
    private final Formula distance;

    public Vision(VisionType type, Formula dist) {
        if (type == null) {
            throw new IllegalArgumentException("Vision Type cannot be null");
        }
        this.visionType = type;
        if (!dist.isValid()) {
            throw new IllegalArgumentException("Vision Type distance must be valid");
        }
        this.distance = dist;
    }

    public Formula getDistance() {
        return this.distance;
    }

    public VisionType getType() {
        return this.visionType;
    }

    public String toString() {
        try {
            return this.toString(Integer.parseInt(this.distance.toString()));
        }
        catch (NumberFormatException e) {
            return this.visionType + " (" + this.distance + ")";
        }
    }

    private String toString(int dist) {
        String vision = this.visionType + " (" + dist + "')";
        if (dist <= 0) {
            vision = this.visionType.toString();
        }
        return vision;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vision) {
            Vision v = (Vision)obj;
            return this.distance.equals(v.distance) && this.visionType.equals(v.visionType);
        }
        return false;
    }

    public int hashCode() {
        return this.distance.hashCode() ^ this.visionType.hashCode();
    }

    public String toString(PlayerCharacter aPC) {
        return this.toString(this.distance.resolve(aPC, "").intValue());
    }

    @Override
    public int compareTo(Vision v) {
        return this.toString().compareTo(v.toString());
    }

    public static Vision getVision(String visionType) {
        Formula distance;
        String type;
        int commaLoc = visionType.indexOf(44);
        if (commaLoc != -1) {
            throw new IllegalArgumentException("Invalid Vision: " + visionType + ". May not contain a comma");
        }
        int quoteLoc = visionType.indexOf(39);
        int openParenLoc = visionType.indexOf(40);
        if (openParenLoc == -1) {
            if (visionType.indexOf(41) != -1) {
                throw new IllegalArgumentException("Invalid Vision: " + visionType + ". Had close paren without open paren");
            }
            if (quoteLoc != -1) {
                throw new IllegalArgumentException("Invalid Vision: " + visionType + ". Had quote parens");
            }
            type = visionType;
            distance = FormulaFactory.ZERO;
        } else {
            int length = visionType.length();
            if (visionType.indexOf(41) != length - 1) {
                throw new IllegalArgumentException("Invalid Vision: " + visionType + ". Close paren not at end of string");
            }
            int endDistance = length - 1;
            if (quoteLoc != -1) {
                if (quoteLoc == length - 2) {
                    --endDistance;
                } else {
                    throw new IllegalArgumentException("Invalid Vision: " + visionType + ". Foot character ' not immediately before close paren");
                }
            }
            type = visionType.substring(0, openParenLoc).trim();
            String dist = visionType.substring(openParenLoc + 1, endDistance);
            if (dist.length() == 0) {
                throw new IllegalArgumentException("Invalid Vision: " + visionType + ". No Distance provided");
            }
            if (quoteLoc != -1) {
                try {
                    Integer.parseInt(dist);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid Vision: " + visionType + ". Vision Distance with Foot character ' was not an integer");
                }
            }
            if (!(distance = FormulaFactory.getFormulaFor(dist)).isValid()) {
                throw new IllegalArgumentException("Invalid: Vision Distance was not valid: " + distance.toString());
            }
        }
        if (type.length() == 0) {
            throw new IllegalArgumentException("Invalid Vision: " + visionType + ". No Vision Type provided");
        }
        return new Vision(VisionType.getVisionType(type), distance);
    }

    @Override
    public boolean isType(String str) {
        return false;
    }

    @Override
    public String getKeyName() {
        return this.toString();
    }

    static {
        VisionList wpl = new VisionList();
        wpl.setName("*Vision");
        VISIONLIST = CDOMDirectSingleRef.getRef(wpl);
    }
}

