/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.kit.BaseKit;

public class KitKit
extends BaseKit {
    private List<CDOMSingleRef<Kit>> availableKits = new ArrayList<CDOMSingleRef<Kit>>();
    private transient Map<Kit, List<BaseKit>> appliedKits = new HashMap<Kit, List<BaseKit>>();

    @Override
    public void apply(PlayerCharacter aPC) {
        for (Map.Entry<Kit, List<BaseKit>> me : this.appliedKits.entrySet()) {
            me.getKey().processKit(aPC, me.getValue());
        }
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        this.appliedKits = new HashMap<Kit, List<BaseKit>>();
        for (CDOMSingleRef<Kit> ref : this.availableKits) {
            Kit addedKit = ref.resolvesTo();
            ArrayList<BaseKit> thingsToAdd = new ArrayList<BaseKit>();
            addedKit.testApplyKit(aPC, thingsToAdd, warnings, true);
            this.appliedKits.put(addedKit, thingsToAdd);
        }
        return true;
    }

    @Override
    public String getObjectName() {
        return "Kit";
    }

    public String toString() {
        return ReferenceUtilities.joinLstFormat(this.availableKits, "|");
    }

    public void addKit(CDOMSingleRef<Kit> ref) {
        this.availableKits.add(ref);
    }

    public List<CDOMSingleRef<Kit>> getKits() {
        return this.availableKits;
    }
}

