/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.base.util.RandomUtil;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.content.CNAbilityFactory;
import pcgen.cdom.content.RollMethod;
import pcgen.cdom.enumeration.FactKey;
import pcgen.cdom.enumeration.Gender;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.ClassSource;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SystemCollections;
import pcgen.core.analysis.DomainApplication;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.analysis.SubClassApplication;
import pcgen.core.character.CharacterSpell;
import pcgen.core.npcgen.AlignGeneratorOption;
import pcgen.core.npcgen.ClassGeneratorOption;
import pcgen.core.npcgen.Configuration;
import pcgen.core.npcgen.GenderGeneratorOption;
import pcgen.core.npcgen.LevelGeneratorOption;
import pcgen.core.npcgen.RaceGeneratorOption;
import pcgen.core.npcgen.SkillChoice;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.spell.Spell;
import pcgen.gui2.UIPropertyContext;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.enumeration.Visibility;

public class NPCGenerator {
    private static final NPCGenerator theInstance = new NPCGenerator();
    private Configuration theConfiguration = null;
    private int theSubSkillWeightAdd = 10;

    private NPCGenerator() {
    }

    public static NPCGenerator getInst() {
        theInstance.setConfiguration(SettingsHandler.getGame());
        return theInstance;
    }

    private void setConfiguration(GameMode aGameMode) {
        this.theConfiguration = Configuration.get(aGameMode);
    }

    public static int getSubSkillWeightAdd() {
        return NPCGenerator.getInst().theSubSkillWeightAdd;
    }

    public List<AlignGeneratorOption> getAlignmentOptions() {
        return this.theConfiguration.getAlignmentOptions();
    }

    public List<RaceGeneratorOption> getCustomRaceOptions() {
        return this.theConfiguration.getRaceOptions();
    }

    public List<GenderGeneratorOption> getCustomGenderOptions() {
        return this.theConfiguration.getGenderOptions();
    }

    public List<ClassGeneratorOption> getCustomClassOptions() {
        return this.theConfiguration.getClassOptions();
    }

    public List<LevelGeneratorOption> getCustomLevelOptions() {
        return this.theConfiguration.getLevelOptions();
    }

    private WeightedCollection<SkillChoice> getSkillWeights(PCClass aClass, PlayerCharacter aPC) {
        WeightedCollection<SkillChoice> WeightedCollection2 = this.theConfiguration.getSkillWeights(aClass.getKeyName());
        if (WeightedCollection2 == null) {
            WeightedCollection2 = new WeightedCollection();
            for (Skill skill : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Skill.class)) {
                if (skill.getSafe(ObjectKey.VISIBILITY) != Visibility.DEFAULT) continue;
                if (aPC.isClassSkill(aClass, skill)) {
                    WeightedCollection2.add(new SkillChoice(skill.getKeyName()), 8);
                    continue;
                }
                if (skill.getSafe(ObjectKey.EXCLUSIVE).booleanValue()) continue;
                WeightedCollection2.add(new SkillChoice(skill.getKeyName()), 1);
            }
        }
        return WeightedCollection2;
    }

    private void selectSkills(PlayerCharacter aPC, WeightedCollection<SkillChoice> skillList, PCClass aClass, int level) {
        PCLevelInfo levelInfo = null;
        int curLevel = 0;
        for (PCLevelInfo li : aPC.getLevelInfo()) {
            if (li.getClassKeyName().equals(aClass.getKeyName())) {
                ++curLevel;
            }
            if (curLevel != level) continue;
            levelInfo = li;
            break;
        }
        if (levelInfo == null) {
            return;
        }
        int skillPts = levelInfo.getSkillPointsRemaining();
        Logging.debugPrint("NPCGenerator: Selecting " + skillPts + " skill points for " + aClass + "/" + level);
        Logging.debugPrint("NPCGenerator: Initial skillList is " + skillList);
        while (skillPts > 0) {
            SkillChoice choice = skillList.getRandomValue();
            Skill skill = choice.getSkill();
            Logging.debugPrint("NPCGenerator: Selected " + skill);
            if (skill == null) {
                Logging.debugPrint("NPCGenerator: Skill not found");
                continue;
            }
            int cost = aPC.getSkillCostForClass(skill, aClass).getCost();
            double ranks = 1.0 / (double)cost;
            Logging.debugPrint("NPCGenerator: Adding " + (int)ranks + "ranks");
            if (!Globals.checkRule("SKILLMAX")) {
                double maxRanks = aPC.getMaxRank(skill, aClass).doubleValue();
                double pcRanks = aPC.getRank(skill).doubleValue();
                if (pcRanks + ranks > maxRanks) {
                    Logging.debugPrint("NPCGenerator: Skill already at max.");
                    boolean ranksLeft = false;
                    for (SkillChoice skillChoice : skillList) {
                        Skill chkSkill = skillChoice.getSkill();
                        if (chkSkill == null || !(aPC.getRank(chkSkill).doubleValue() < aPC.getMaxRank(chkSkill, aClass).doubleValue())) continue;
                        ranksLeft = true;
                        break;
                    }
                    if (ranksLeft) continue;
                    Logging.errorPrint("Unable to spend all skill points.");
                    break;
                }
            }
            SkillRankControl.modRanks(ranks, aClass, false, aPC, skill);
            skillList.add(choice, 4 / cost);
            levelInfo.setSkillPointsRemaining(--skillPts);
            Logging.debugPrint("NPCGenerator: Skill list now " + skillList);
        }
    }

    private PCAlignment getAlignment(AlignGeneratorOption option) {
        if (option == null) {
            return null;
        }
        return option.getList().getRandomValue();
    }

    private Race getRace(RaceGeneratorOption option) {
        return option.getList().getRandomValue();
    }

    private Gender getGender(GenderGeneratorOption option) {
        return option.getList().getRandomValue();
    }

    private PCClass getClass(ClassGeneratorOption option) {
        return option.getList().getRandomValue();
    }

    private int getLevel(LevelGeneratorOption option) {
        return option.getList().getRandomValue();
    }

    private List<PCStat> getStatWeights(PlayerCharacter pc, PCClass aClass) {
        WeightedCollection<PCStat> stats = new WeightedCollection<PCStat>(this.theConfiguration.getStatWeights(aClass.getKeyName()));
        ArrayList<PCStat> ret = new ArrayList<PCStat>();
        for (int i = 0; i < pc.getDisplay().getStatCount(); ++i) {
            PCStat stat = stats.getRandomValue();
            ret.add(stat);
            stats.remove(stat);
        }
        return ret;
    }

    private void generateStats(PlayerCharacter aPC, PCClass aClass, RollMethod aRollMethod) {
        List<PCStat> statOrder = this.getStatWeights(aPC, aClass);
        Logging.debugPrint("NPCGenerator: Stat order is " + statOrder);
        aPC.rollStats(3, statOrder, aRollMethod, true);
        for (PCStat stat : aPC.getStatSet()) {
            Logging.debugPrint("NPCGenerator: Setting stat " + stat.getKeyName() + " to " + aPC.getStat(stat));
            aPC.setStat(stat, aPC.getStat(stat));
        }
    }

    private WeightedCollection<Ability> getFeatWeights(PCClass aClass) {
        WeightedCollection<Ability> weightedCollection = this.theConfiguration.getAbilityWeights(aClass.getKeyName(), AbilityCategory.FEAT);
        if (weightedCollection == null) {
            weightedCollection = new WeightedCollection();
            for (Ability ability : Globals.getContext().getReferenceContext().getManufacturer(Ability.class, AbilityCategory.FEAT).getAllObjects()) {
                int weight = 1;
                if (ability.getSafe(ObjectKey.VISIBILITY) != Visibility.DEFAULT) continue;
                if (ability.isType("GENERAL")) {
                    weight = 5;
                }
                weightedCollection.add(ability, weight);
            }
        }
        return weightedCollection;
    }

    private void selectFeats(PlayerCharacter aPC, WeightedCollection<Ability> aFeatList) {
        while ((int)aPC.getRemainingFeatPoolPoints() > 0) {
            Ability ability = aFeatList.getRandomValue();
            if (!ability.qualifies(aPC, ability)) continue;
            AbilityUtilities.driveChooseAndAdd(CNAbilityFactory.getCNAbility(AbilityCategory.FEAT, Nature.NORMAL, ability), aPC, true);
        }
    }

    private void selectDeity(PlayerCharacter aPC, PCClass aClass) {
        WeightedCollection<Deity> deities = new WeightedCollection<Deity>(this.theConfiguration.getDeityWeights(aClass.getKeyName()));
        boolean selected = false;
        while (deities.size() > 0) {
            Deity deity = deities.getRandomValue();
            if (aPC.canSelectDeity(deity)) {
                aPC.setDeity(deity);
                selected = true;
                break;
            }
            deities.remove(deity);
        }
        if (!selected) {
            Logging.errorPrintLocalised("NPCGen.Errors.CantSelectDeity");
        }
    }

    private void selectDomains(PlayerCharacter aPC, PCClass aClass) {
        WeightedCollection<Domain> domains = this.theConfiguration.getDomainWeights(aPC.getDeity().getKeyName(), aClass.getKeyName());
        Iterator<Domain> iterator = domains.iterator();
        while (iterator.hasNext()) {
            Domain domain = iterator.next();
            if (domain.qualifies(aPC, domain)) continue;
            iterator.remove();
        }
        if (domains.size() == 0) {
            return;
        }
        while (aPC.getDomainCount() < aPC.getMaxCharacterDomains()) {
            Domain domain = domains.getRandomValue();
            if (aPC.hasDomain(domain)) continue;
            aPC.addDomain(domain, new ClassSource(aClass));
            DomainApplication.applyDomain(aPC, domain);
            aPC.calcActiveBonuses();
        }
    }

    private WeightedCollection<Spell> getKnownSpellWeights(PlayerCharacter pc, PCClass aClass, int aLevel) {
        WeightedCollection<Spell> WeightedCollection2 = this.theConfiguration.getKnownSpellWeights(pc, aClass.getKeyName(), aLevel);
        if (WeightedCollection2 == null) {
            WeightedCollection2 = new WeightedCollection();
            for (Spell spell : pc.getSpellsIn(aClass.get(ObjectKey.CLASS_SPELLLIST), aLevel)) {
                WeightedCollection2.add(spell, 1);
            }
        }
        return WeightedCollection2;
    }

    private WeightedCollection<Spell> getPreparedSpellWeights(PlayerCharacter pc, PCClass aClass, int aLevel) {
        WeightedCollection<Spell> WeightedCollection2 = this.theConfiguration.getPreparedSpellWeights(aClass.getKeyName(), aLevel, pc);
        if (WeightedCollection2 == null) {
            WeightedCollection2 = new WeightedCollection();
            for (Spell spell : pc.getSpellsIn(aClass.get(ObjectKey.CLASS_SPELLLIST), aLevel)) {
                WeightedCollection2.add(spell, 1);
            }
        }
        return WeightedCollection2;
    }

    private void selectDomainSpell(PlayerCharacter aPC, PCClass aClass, int aLevel) {
        if (!aPC.hasDomains()) {
            return;
        }
        WeightedCollection<Domain> domains = new WeightedCollection<Domain>();
        for (Domain d : aPC.getDomainSet()) {
            if (!aClass.equals(aPC.getDomainSource(d).getPcclass())) continue;
            domains.add(d);
        }
        Domain domain = (Domain)domains.getRandomValue();
        WeightedCollection<Spell> domainSpells = new WeightedCollection<Spell>(aPC.getSpellsIn(domain.get(ObjectKey.DOMAIN_SPELLLIST), aLevel));
        this.selectSpell(aPC, aClass, domain, "Prepared Spells", domainSpells, aLevel);
    }

    private void selectSpell(PlayerCharacter aPC, PCClass aClass, Domain aDomain, String aBookName, WeightedCollection<Spell> aSpellList, int aLevel) {
        boolean added = false;
        while (!added) {
            Spell spell = aSpellList.getRandomValue();
            CharacterSpell cs = aDomain != null ? new CharacterSpell(aDomain, spell) : new CharacterSpell(aClass, spell);
            String aString = aPC.addSpell(cs, new ArrayList<Ability>(), aClass.getKeyName(), aBookName, aLevel, aLevel);
            if (aString.length() != 0) {
                Logging.debugPrint("Add spell failed: " + aString);
                continue;
            }
            added = true;
        }
    }

    private void selectSubClass(PlayerCharacter aPC, PCClass aClass) {
        WeightedCollection<String> subClasses = this.theConfiguration.getSubClassWeights(aClass.getKeyName());
        if (subClasses != null && subClasses.size() > 0) {
            SubClassApplication.setSubClassKey(aPC, aClass, subClasses.getRandomValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(PlayerCharacter aPC, AlignGeneratorOption align, RaceGeneratorOption aRace, GenderGeneratorOption aGender, List<ClassGeneratorOption> classList, List<LevelGeneratorOption> levels, RollMethod aRollMethod) {
        ChooserFactory.pushChooserClassname("pcgen.util.chooser.RandomChooser");
        boolean tempShowHP = SettingsHandler.getShowHPDialogAtLevelUp();
        SettingsHandler.setShowHPDialogAtLevelUp(false);
        int tempChoicePref = UIPropertyContext.getSingleChoiceAction();
        UIPropertyContext.setSingleChoiceAction(2);
        try {
            int MAX_RETRIES = 5;
            for (int i = 0; i < 5; ++i) {
                Race r;
                PCAlignment randAlign = this.getAlignment(align);
                if (randAlign != null) {
                    Logging.debugPrint("NPCGenerator: Selected " + randAlign + " for alignment " + align);
                    aPC.setAlignment(randAlign);
                }
                if ((r = this.getRace(aRace)) == null) {
                    Logging.debugPrint("NPCGenerator: Got null race.  Retrying.");
                    continue;
                }
                Logging.debugPrint("NPCGenerator: Selected " + r + " for race " + aRace);
                if (!r.qualifies(aPC, r)) continue;
                Logging.debugPrint("NPCGenerator: PC qualifies for race " + r);
                aPC.setRace(r);
                break;
            }
            if (aPC.getRace() == Globals.s_EMPTYRACE) {
                Logging.errorPrint("Unable to select race");
                return;
            }
            Gender gender = this.getGender(aGender);
            Logging.debugPrint("NPCGenerator: Selecting " + gender + " for gender " + aGender);
            aPC.setGender(gender);
            boolean doneRacialClasses = false;
            for (int i = 0; i < classList.size(); ++i) {
                int numLevels = this.getLevel(levels.get(i));
                Logging.debugPrint("NPCGenerator: Selecting " + numLevels + " for level " + levels.get(i));
                PCClass aClass = null;
                if (!doneRacialClasses && aPC.hasClass()) {
                    aClass = aPC.getClassList().get(0);
                    numLevels = aPC.getLevel(aClass);
                    doneRacialClasses = true;
                    --i;
                } else {
                    doneRacialClasses = true;
                    aClass = this.getClass(classList.get(i));
                    if (aClass != null) {
                        if (aClass.getSafe(ObjectKey.VISIBILITY).equals((Object)Visibility.DEFAULT) && aClass.qualifies(aPC, aClass)) {
                            Logging.debugPrint("NPCGenerator: Selecting " + aClass + " for class " + classList.get(i));
                        } else {
                            Logging.errorPrint("Counld not add a level of " + aClass);
                            aClass = null;
                        }
                    }
                }
                if (aClass == null) continue;
                PCClass classCopy = aClass.clone();
                if (classCopy.containsListFor(ListKey.SUB_CLASS)) {
                    this.selectSubClass(aPC, classCopy);
                }
                if (i == 0) {
                    this.generateStats(aPC, classCopy, aRollMethod);
                    this.selectDeity(aPC, classCopy);
                }
                int highestSpellLevel = aPC.getSpellSupport(aClass).getHighestLevelSpell(aPC);
                int[] selectedSpells = new int[highestSpellLevel + 1];
                for (int k = 0; k < highestSpellLevel; ++k) {
                    selectedSpells[k] = 0;
                }
                int[] bonusSpells = new int[highestSpellLevel + 1];
                for (int k = 0; k < highestSpellLevel; ++k) {
                    bonusSpells[k] = 0;
                }
                WeightedCollection<SkillChoice> skillList = new WeightedCollection<SkillChoice>(this.getSkillWeights(classCopy, aPC));
                WeightedCollection<Ability> featList = new WeightedCollection<Ability>(this.getFeatWeights(classCopy));
                for (int j = 0; j < numLevels; ++j) {
                    int lvl;
                    if (i >= 0) {
                        aPC.incrementClassLevel(1, classCopy, true);
                    }
                    PCClass pcClass = aPC.getClassKeyed(classCopy.getKeyName());
                    this.selectSkills(aPC, skillList, pcClass, j + 1);
                    this.selectFeats(aPC, featList);
                    this.selectDomains(aPC, pcClass);
                    if (pcClass.get(FactKey.valueOf("SpellType")) == null) continue;
                    if (aPC.getSpellSupport(pcClass).hasKnownList() || aPC.getSpellSupport(pcClass).hasKnownSpells(aPC)) {
                        Logging.debugPrint("NPCGenerator: known spells to select");
                        for (lvl = 0; lvl <= highestSpellLevel; ++lvl) {
                            if (!aPC.availableSpells(lvl, pcClass, Globals.getDefaultSpellBook(), true, true)) continue;
                            int a = aPC.getSpellSupport(pcClass).getKnownForLevel(lvl, "null", aPC);
                            Logging.debugPrint("NPCGenerator: " + a + "known spells to select");
                            WeightedCollection<Spell> spellChoices = this.getKnownSpellWeights(aPC, pcClass, lvl);
                            int numToSelect = a - selectedSpells[lvl];
                            for (int sp = 0; sp < numToSelect; ++sp) {
                                this.selectSpell(aPC, pcClass, null, Globals.getDefaultSpellBook(), spellChoices, lvl);
                                int n = lvl;
                                selectedSpells[n] = selectedSpells[n] + 1;
                            }
                        }
                        continue;
                    }
                    Logging.debugPrint("NPCGenerator: prepared spells to select");
                    aPC.addSpellBook("Prepared Spells");
                    for (lvl = 0; lvl <= highestSpellLevel; ++lvl) {
                        int castTot = aPC.getSpellSupport(pcClass).getCastForLevel(lvl, "Prepared Spells", true, true, aPC);
                        int castNon = aPC.getSpellSupport(pcClass).getCastForLevel(lvl, "Prepared Spells", false, true, aPC);
                        int castSpec = castTot - castNon;
                        Logging.debugPrint("NPCGenerator: " + castTot + "+" + castSpec + " prepared spells to select");
                        if (castSpec - bonusSpells[lvl] > 0) {
                            this.selectDomainSpell(aPC, pcClass, lvl);
                            int n = lvl;
                            bonusSpells[n] = bonusSpells[n] + 1;
                        }
                        if (castTot <= 0) continue;
                        WeightedCollection<Spell> spellChoices = this.getPreparedSpellWeights(aPC, pcClass, lvl);
                        int numToSelect = castNon - selectedSpells[lvl];
                        for (int sp = 0; sp < numToSelect; ++sp) {
                            this.selectSpell(aPC, pcClass, null, "Prepared Spells", spellChoices, lvl);
                            int n = lvl;
                            selectedSpells[n] = selectedSpells[n] + 1;
                        }
                    }
                }
            }
            String randBioString = "EYES.HAIR.SKIN.HT.WT.AGE.";
            aPC.getBioSet().randomize("EYES.HAIR.SKIN.HT.WT.AGE.", aPC);
            List<String> globalHairStyleList = SystemCollections.getUnmodifiableHairStyleList();
            aPC.setHairStyle(globalHairStyleList.get(RandomUtil.getRandomInt(globalHairStyleList.size())));
            List<String> speechList = SystemCollections.getUnmodifiableSpeechList();
            aPC.setSpeechTendency(speechList.get(RandomUtil.getRandomInt(speechList.size())));
            List<String> globalPhobiaList = SystemCollections.getUnmodifiablePhobiaList();
            aPC.setPhobias(globalPhobiaList.get(RandomUtil.getRandomInt(globalPhobiaList.size())));
            List<String> globalInterestsList = SystemCollections.getUnmodifiableInterestsList();
            aPC.setInterests(globalInterestsList.get(RandomUtil.getRandomInt(globalInterestsList.size())));
            List<String> globalPhraseList = SystemCollections.getUnmodifiablePhraseList();
            aPC.setCatchPhrase(globalPhraseList.get(RandomUtil.getRandomInt(globalPhraseList.size())));
            List<String> globalTraitList = SystemCollections.getUnmodifiableTraitList();
            aPC.setTrait1(globalTraitList.get(RandomUtil.getRandomInt(globalTraitList.size())));
            aPC.setTrait2(globalTraitList.get(RandomUtil.getRandomInt(globalTraitList.size())));
            List<String> globalCityList = SystemCollections.getUnmodifiableCityList();
            aPC.setResidence(globalCityList.get(RandomUtil.getRandomInt(globalCityList.size())));
            List<String> globalLocationList = SystemCollections.getUnmodifiableLocationList();
            aPC.setLocation(globalLocationList.get(RandomUtil.getRandomInt(globalLocationList.size())));
            List<String> globalBirthplaceList = SystemCollections.getUnmodifiableBirthplaceList();
            aPC.setBirthplace(globalBirthplaceList.get(RandomUtil.getRandomInt(globalBirthplaceList.size())));
        }
        catch (Exception e) {
            Logging.errorPrint("Problem generation NPC", e);
        }
        finally {
            SettingsHandler.setShowHPDialogAtLevelUp(tempShowHP);
            UIPropertyContext.setSingleChoiceAction(tempChoicePref);
            ChooserFactory.popChooserClassname();
        }
    }
}

