/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.utils;

import java.util.Stack;
import java.util.StringTokenizer;

public class LastGroupSeparator {
    private final String startingString;
    private StringBuilder root = null;

    public LastGroupSeparator(String baseString) {
        if (baseString == null) {
            throw new IllegalArgumentException("Choose Separator cannot take null initialization String");
        }
        this.startingString = baseString;
    }

    public String process() throws GroupingMismatchException {
        StringTokenizer base = new StringTokenizer(this.startingString, "()", true);
        int sbLength = this.startingString.length();
        this.root = new StringBuilder(sbLength);
        StringBuilder temp = new StringBuilder(sbLength);
        boolean isValid = false;
        Stack<String> expected = new Stack<String>();
        while (base.hasMoreTokens()) {
            String working = base.nextToken();
            if (expected.isEmpty()) {
                if (isValid) {
                    this.root.append('(');
                    this.root.append((CharSequence)temp);
                    this.root.append(')');
                }
                temp = new StringBuilder(sbLength);
                isValid = false;
            }
            if ("(".equals(working)) {
                if (!expected.isEmpty()) {
                    temp.append(working);
                }
                isValid = true;
                expected.push(")");
                continue;
            }
            if (")".equals(working)) {
                if (expected.isEmpty()) {
                    throw new GroupingMismatchException(this.startingString + " did not have an open parenthesis " + "before close: " + temp.toString());
                }
                if (!")".equals(expected.pop())) {
                    throw new GroupingMismatchException(this.startingString + " did not have matching parenthesis " + "inside of brackets: " + temp.toString());
                }
                if (expected.isEmpty()) continue;
                temp.append(working);
                continue;
            }
            if (expected.isEmpty()) {
                this.root.append(working);
                continue;
            }
            temp.append(working);
        }
        if (expected.isEmpty()) {
            if (!isValid) {
                return null;
            }
            return temp.toString();
        }
        throw new GroupingMismatchException(this.startingString + " reached end of String while attempting to match: " + (String)expected.pop());
    }

    public String getRoot() {
        if (this.root == null) {
            throw new IllegalStateException();
        }
        return this.root.toString();
    }

    public static class GroupingMismatchException
    extends IllegalStateException {
        public GroupingMismatchException(String base) {
            super(base);
        }
    }
}

