/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.BonusManager;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.EquipBonus;
import pcgen.core.display.BonusDisplay;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.PrereqHandler;
import pcgen.facade.core.ChooserFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.core.UIDelegate;
import pcgen.gui2.facade.GeneralChooserFacadeBase;
import pcgen.gui2.facade.TempBonusFacadeImpl;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class TempBonusHelper {
    private static final String EMPTY_STRING = "";

    static Object getTempBonusTarget(CDOMObject originObj, PlayerCharacter theCharacter, UIDelegate delegate, InfoFactory infoFactory) {
        List<InfoFacade> possibleTargets = TempBonusHelper.getListOfApplicableEquipment(originObj, theCharacter);
        boolean canApplyToPC = TempBonusHelper.hasCharacterTempBonus(originObj, theCharacter);
        if (possibleTargets.isEmpty()) {
            if (canApplyToPC) {
                return theCharacter;
            }
            delegate.showInfoMessage("PCGen", LanguageBundle.getString("in_itmNoSuitableEquip"));
            return null;
        }
        String label = LanguageBundle.getString("im_itmSelectItem");
        if (canApplyToPC) {
            possibleTargets.add(new CharacterInfoFacade(theCharacter.getDisplay()));
        }
        final ArrayList selectedList = new ArrayList();
        GeneralChooserFacadeBase chooserFacade = new GeneralChooserFacadeBase(label, possibleTargets, new ArrayList(), 1, infoFactory){

            @Override
            public void commit() {
                for (InfoFacade item : this.getSelectedList()) {
                    selectedList.add(item);
                }
            }
        };
        chooserFacade.setDefaultView(ChooserFacade.ChooserTreeViewType.NAME);
        delegate.showGeneralChooser(chooserFacade);
        if (!selectedList.isEmpty()) {
            if (selectedList.get(0) instanceof CharacterInfoFacade) {
                return theCharacter;
            }
            Equipment aEq = ((Equipment)selectedList.get(0)).clone();
            aEq.makeVirtual();
            String currAppName = aEq.getAppliedName();
            if (currAppName != null && currAppName.length() > 2) {
                if (theCharacter.hasTempApplied(originObj)) {
                    delegate.showInfoMessage("PCGen", LanguageBundle.getString("in_itmAppBonButAlreadyApplied"));
                    return null;
                }
                aEq.setAppliedName(currAppName.substring(2, currAppName.length() - 1) + ", " + originObj.getKeyName());
            } else {
                aEq.setAppliedName(originObj.getKeyName());
            }
            return aEq;
        }
        return null;
    }

    public static List<InfoFacade> getListOfApplicableEquipment(CDOMObject originObj, PlayerCharacter theCharacter) {
        CharacterDisplay charDisplay = theCharacter.getDisplay();
        ArrayList<InfoFacade> possibleEquipment = new ArrayList<InfoFacade>();
        if (originObj == null) {
            return possibleEquipment;
        }
        boolean found = false;
        theCharacter.setCalcEquipmentList(theCharacter.getUseTempMods());
        for (Equipment aEq : charDisplay.getEquipmentSet()) {
            found = false;
            for (EquipBonus eb : originObj.getSafeListFor(ListKey.BONUS_EQUIP)) {
                String conditions = eb.conditions;
                boolean passesConditions = TempBonusHelper.passesConditions(aEq, conditions);
                if (!passesConditions || found) continue;
                possibleEquipment.add(aEq);
                found = true;
            }
        }
        return possibleEquipment;
    }

    private static boolean passesConditions(Equipment aEq, String conditions) {
        for (String andToken : conditions.split(",")) {
            boolean passOr = false;
            for (String orToken : andToken.split("\\;")) {
                if (orToken.startsWith("[")) {
                    if (aEq.isType(orToken.substring(1, orToken.length() - 1))) continue;
                    passOr = true;
                    break;
                }
                if (!aEq.isType(orToken)) continue;
                passOr = true;
                break;
            }
            if (passOr) continue;
            return false;
        }
        return true;
    }

    static TempBonusFacadeImpl applyBonusToCharacterEquipment(Equipment aEq, CDOMObject originObj, PlayerCharacter theCharacter) {
        TempBonusFacadeImpl appliedBonus = null;
        String repeatValue = EMPTY_STRING;
        for (EquipBonus eb : originObj.getListFor(ListKey.BONUS_EQUIP)) {
            BonusObj newB;
            String oldValue;
            BonusObj aBonus = eb.bonus;
            String newValue = oldValue = aBonus.toString();
            if (originObj.getSafe(StringKey.TEMPVALUE).length() > 0) {
                BonusInfo bi = TempBonusHelper.getBonusChoice(oldValue, originObj, repeatValue, theCharacter);
                if (bi == null) {
                    return null;
                }
                newValue = bi.getBonusValue();
                repeatValue = bi.getRepeatValue();
            }
            if ((newB = Bonus.newBonus(Globals.getContext(), newValue)) == null) continue;
            theCharacter.setApplied(newB, PrereqHandler.passesAll(newB.getPrerequisiteList(), aEq, theCharacter));
            aEq.addTempBonus(newB);
            BonusManager.TempBonusInfo tempBonusInfo = theCharacter.addTempBonus(newB, originObj, aEq);
            if (appliedBonus != null) continue;
            String bonusName = BonusDisplay.getBonusDisplayName(tempBonusInfo);
            appliedBonus = new TempBonusFacadeImpl(originObj, aEq, bonusName);
        }
        if (aEq != null) {
            theCharacter.addTempBonusItemList(aEq);
        }
        return appliedBonus;
    }

    static TempBonusFacadeImpl applyBonusToCharacter(CDOMObject originObj, PlayerCharacter theCharacter) {
        TempBonusFacadeImpl appliedBonus = null;
        String repeatValue = EMPTY_STRING;
        for (BonusObj aBonus : TempBonusHelper.getTempCharBonusesFor(originObj, theCharacter)) {
            BonusObj newB;
            String oldValue;
            String newValue = oldValue = aBonus.toString();
            if (originObj.getSafe(StringKey.TEMPVALUE).length() > 0) {
                BonusInfo bi = TempBonusHelper.getBonusChoice(oldValue, originObj, repeatValue, theCharacter);
                if (bi == null) {
                    return null;
                }
                newValue = bi.getBonusValue();
                repeatValue = bi.getRepeatValue();
            }
            if ((newB = Bonus.newBonus(Globals.getContext(), newValue)) == null) continue;
            theCharacter.setApplied(newB, newB.qualifies(theCharacter, null));
            BonusManager.TempBonusInfo tempBonusInfo = theCharacter.addTempBonus(newB, originObj, theCharacter);
            if (appliedBonus != null) continue;
            String bonusName = BonusDisplay.getBonusDisplayName(tempBonusInfo);
            appliedBonus = new TempBonusFacadeImpl(originObj, theCharacter, bonusName);
        }
        return appliedBonus;
    }

    private static List<BonusObj> getTempCharBonusesFor(CDOMObject originObj, PlayerCharacter theCharacter) {
        ArrayList<BonusObj> list = new ArrayList<BonusObj>(5);
        list.addAll(originObj.getSafeListFor(ListKey.BONUS_ANYPC));
        list.addAll(originObj.getSafeListFor(ListKey.BONUS_PC));
        return list;
    }

    static void removeBonusFromCharacter(PlayerCharacter pc, Equipment aEq, CDOMObject aCreator) {
        for (Map.Entry<BonusObj, BonusManager.TempBonusInfo> me : pc.getTempBonusMap().entrySet()) {
            BonusObj aBonus = me.getKey();
            BonusManager.TempBonusInfo tbi = me.getValue();
            Object aC = tbi.source;
            if (aCreator != aC) continue;
            Object aT = tbi.target;
            if (aT instanceof Equipment && aEq != null) {
                if (!aEq.equals(aT)) continue;
                pc.removeTempBonus(aBonus);
                pc.removeTempBonusItemList((Equipment)aT);
                ((Equipment)aT).removeTempBonus(aBonus);
                ((Equipment)aT).setAppliedName(EMPTY_STRING);
                continue;
            }
            if (!(aT instanceof PlayerCharacter) || aEq != null) continue;
            pc.removeTempBonus(aBonus);
        }
    }

    private static BonusInfo getBonusChoice(String oldValue, CDOMObject source, String repeatValue, PlayerCharacter pc) {
        String value = oldValue;
        if (repeatValue.length() > 0) {
            if (value.indexOf("%CHOICE") >= 0) {
                value = value.replaceAll(Pattern.quote("%CHOICE"), repeatValue);
            }
            return new BonusInfo(value, repeatValue);
        }
        String aChoice = source.getSafe(StringKey.TEMPVALUE);
        StringTokenizer aTok = new StringTokenizer(aChoice, "|");
        String minString = aTok.nextToken().substring(4);
        String maxString = aTok.nextToken().substring(4);
        String titleString = aTok.nextToken().substring(6);
        int min = pc.getVariableValue(minString, EMPTY_STRING).intValue();
        int max = pc.getVariableValue(maxString, EMPTY_STRING).intValue();
        if (max < min) {
            Logging.errorPrint("Temp Bonus Value had max < min: " + max + "<" + min);
            return null;
        }
        if (max <= 0) {
            Logging.errorPrint("Temp Bonus Value had max <= 0: " + max);
            return null;
        }
        ArrayList<Integer> numberList = new ArrayList<Integer>();
        for (int i = min; i <= max; ++i) {
            numberList.add(i);
        }
        List selectedList = new ArrayList();
        if ((selectedList = Globals.getChoiceFromList(titleString, numberList, selectedList, 1, false, true, pc)).size() > 0) {
            String aI = String.valueOf(selectedList.get(0));
            if (oldValue.indexOf("%CHOICE") >= 0) {
                value = oldValue.replaceAll(Pattern.quote("%CHOICE"), aI);
            }
            return new BonusInfo(value, aI);
        }
        return null;
    }

    public static boolean hasAnyPCTempBonus(CDOMObject obj, PlayerCharacter theCharacter) {
        return obj.containsListFor(ListKey.BONUS_ANYPC);
    }

    public static boolean hasPCTempBonus(CDOMObject obj, PlayerCharacter theCharacter) {
        return obj.containsListFor(ListKey.BONUS_PC);
    }

    public static boolean hasNonPCTempBonus(CDOMObject obj, PlayerCharacter theCharacter) {
        return TempBonusHelper.hasEquipmentTempBonus(obj, theCharacter) || TempBonusHelper.hasAnyPCTempBonus(obj, theCharacter);
    }

    public static boolean hasCharacterTempBonus(CDOMObject obj, PlayerCharacter theCharacter) {
        return TempBonusHelper.hasAnyPCTempBonus(obj, theCharacter) || TempBonusHelper.hasPCTempBonus(obj, theCharacter);
    }

    public static boolean hasEquipmentTempBonus(CDOMObject obj, PlayerCharacter theCharacter) {
        return obj.containsListFor(ListKey.BONUS_EQUIP);
    }

    public static Set<String> getEquipmentApplyString(CDOMObject obj, PlayerCharacter theCharacter) {
        HashSet<String> set = new HashSet<String>();
        for (EquipBonus bonus : obj.getListFor(ListKey.BONUS_EQUIP)) {
            set.add(bonus.conditions);
        }
        return set;
    }

    public static boolean hasTempBonus(CDOMObject obj, PlayerCharacter theCharacter) {
        return TempBonusHelper.hasEquipmentTempBonus(obj, theCharacter) || TempBonusHelper.hasAnyPCTempBonus(obj, theCharacter) || TempBonusHelper.hasPCTempBonus(obj, theCharacter);
    }

    static class CharacterInfoFacade
    implements InfoFacade {
        private final CharacterDisplay charDisplay;

        public CharacterInfoFacade(CharacterDisplay charDisplay) {
            this.charDisplay = charDisplay;
        }

        @Override
        public String getSource() {
            return TempBonusHelper.EMPTY_STRING;
        }

        @Override
        public String getSourceForNodeDisplay() {
            return TempBonusHelper.EMPTY_STRING;
        }

        @Override
        public String getKeyName() {
            return "PC";
        }

        @Override
        public boolean isNamePI() {
            return false;
        }

        @Override
        public String toString() {
            return LanguageBundle.getFormattedString("in_itmCharacterName", this.charDisplay.getName());
        }

        @Override
        public String getType() {
            return TempBonusHelper.EMPTY_STRING;
        }
    }

    static class BonusInfo {
        private final String bonusValue;
        private final String repeatValue;

        public BonusInfo(String value, String repeat) {
            this.bonusValue = value;
            this.repeatValue = repeat;
        }

        public String getBonusValue() {
            return this.bonusValue;
        }

        public String getRepeatValue() {
            return this.repeatValue;
        }
    }
}

