/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import pcgen.util.Logging;

public final class WholeNumberField
extends JTextField
implements Serializable {
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.US);

    public WholeNumberField() {
        this(0, 0);
    }

    public WholeNumberField(int value, int columns) {
        super(columns);
        this.integerFormatter.setParseIntegerOnly(true);
        this.setValue(value);
    }

    public void setValue(int value) {
        this.setText(Integer.toString(value));
    }

    public int getValue() {
        int retVal = 0;
        try {
            String text = this.getText();
            if (text == null || text.trim().length() == 0) {
                text = "0";
            }
            retVal = this.integerFormatter.parse(text).intValue();
        }
        catch (ParseException e) {
            Logging.errorPrint("Failed to parse WholeNumber value.", e);
        }
        return retVal;
    }

    @Override
    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    private static class WholeNumberDocument
    extends PlainDocument {
        private WholeNumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (i == 0 && source[i] == '-') {
                    result[j++] = source[i];
                    continue;
                }
                if (Character.isDigit(source[i])) {
                    result[j++] = source[i];
                    continue;
                }
                Logging.errorPrint("insertString: " + source[i] + " in " + str);
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

