/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import pcgen.io.EntityMap;

public final class EntityEncoder {
    private static final String ENCODE = "\\\n\r\f:|[]&";
    private static final EntityMap ENTITIES = new EntityMap();
    private static final String ENCODE_LIGHT = "\\\n\r\f|&";
    private static final EntityMap ENTITIES_LIGHT;

    private EntityEncoder() {
    }

    public static String decode(String s) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(s, "&;", true);
        while (tokens.hasMoreTokens()) {
            String cToken = tokens.nextToken();
            if ("&".equals(cToken)) {
                String tok1 = null;
                String tok2 = null;
                try {
                    tok1 = tokens.nextToken();
                    tok2 = tokens.nextToken();
                    buffer.append(ENTITIES.get(cToken + tok1 + tok2));
                }
                catch (NoSuchElementException exc) {
                    buffer.append(cToken);
                    if (tok1 == null) continue;
                    buffer.append(tok1);
                    if (tok2 == null) continue;
                    buffer.append(tok2);
                }
                continue;
            }
            buffer.append(cToken);
        }
        return buffer.toString();
    }

    public static String encode(String s) {
        StringBuilder buffer = new StringBuilder();
        if (s != null) {
            StringTokenizer tokens = new StringTokenizer(s, ENCODE, true);
            while (tokens.hasMoreTokens()) {
                buffer.append(ENTITIES.get(tokens.nextToken()));
            }
        }
        return buffer.toString();
    }

    public static String encodeLight(String s) {
        StringBuilder buffer = new StringBuilder();
        if (s != null) {
            StringTokenizer tokens = new StringTokenizer(s, ENCODE_LIGHT, true);
            while (tokens.hasMoreTokens()) {
                buffer.append(ENTITIES_LIGHT.get(tokens.nextToken()));
            }
        }
        return buffer.toString();
    }

    static {
        ENTITIES.put("\n", "&nl;");
        ENTITIES.put("\r", "&cr;");
        ENTITIES.put("\f", "&lf;");
        ENTITIES.put(":", "&colon;");
        ENTITIES.put("|", "&pipe;");
        ENTITIES.put("[", "&lbracket;");
        ENTITIES.put("]", "&rbracket;");
        ENTITIES.put("&", "&amp;");
        ENTITIES_LIGHT = new EntityMap();
        ENTITIES_LIGHT.put("\n", "&nl;");
        ENTITIES_LIGHT.put("\r", "&cr;");
        ENTITIES_LIGHT.put("\f", "&lf;");
        ENTITIES_LIGHT.put("|", "&pipe;");
        ENTITIES_LIGHT.put("&", "&amp;");
    }
}

