/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.token;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import pcgen.base.util.MapToList;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.core.spell.Spell;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;

public abstract class AbstractSpellListToken
extends AbstractTokenWithSeparator<CDOMObject> {
    @Override
    protected char separator() {
        return '|';
    }

    protected TripleKeyMapToList<String, Integer, CDOMReference<? extends CDOMList<?>>, CDOMReference<Spell>> getMap(LoadContext context, CDOMObject obj, Collection<CDOMReference<? extends CDOMList<?>>> changedLists, boolean knownSpells) {
        TripleKeyMapToList map = new TripleKeyMapToList();
        for (CDOMReference<CDOMList<?>> cDOMReference : changedLists) {
            AssociatedChanges<CDOMReference<?>> changes = context.getListContext().getChangesInList(this.getTokenName(), obj, cDOMReference);
            Collection<CDOMReference<?>> removedItems = changes.getRemoved();
            if (removedItems != null && !removedItems.isEmpty() || changes.includesGlobalClear()) {
                context.addWriteMessage(this.getTokenName() + " does not support .CLEAR");
                return null;
            }
            MapToList<CDOMReference<?>, AssociatedPrereqObject> mtl = changes.getAddedAssociations();
            if (mtl == null || mtl.isEmpty()) continue;
            for (CDOMReference added : mtl.getKeySet()) {
                for (AssociatedPrereqObject assoc : mtl.getListFor((Object)added)) {
                    Integer lvl = assoc.getAssociation(AssociationKey.SPELL_LEVEL);
                    String prereqString = this.getPrerequisiteString(context, assoc.getPrerequisiteList());
                    Boolean known = assoc.getAssociation(AssociationKey.KNOWN);
                    boolean isKnown = known != null && known != false;
                    if (knownSpells != isKnown) continue;
                    map.addToListFor((Object)prereqString, (Object)lvl, cDOMReference, (Object)added);
                }
            }
        }
        return map;
    }

    protected StringBuilder processUnparse(String type, TripleKeyMapToList<String, Integer, CDOMReference<? extends CDOMList<?>>, CDOMReference<Spell>> domainMap, String prereqs) {
        StringBuilder sb = new StringBuilder(type);
        Set levels = domainMap.getSecondaryKeySet((Object)prereqs);
        for (Integer level : new TreeSet(levels)) {
            for (CDOMReference list : domainMap.getTertiaryKeySet((Object)prereqs, (Object)level)) {
                sb.append("|");
                String lsts = list.getLSTformat(false);
                if (lsts.startsWith("TYPE=")) {
                    lsts = "SPELLCASTER." + lsts.substring(5);
                }
                sb.append(lsts);
                sb.append("=");
                sb.append(level);
                sb.append("|");
                List refs = domainMap.getListFor((Object)prereqs, (Object)level, (Object)list);
                boolean first = true;
                for (CDOMReference lw : refs) {
                    if (!first) {
                        sb.append(',');
                    }
                    first = false;
                    sb.append(lw.getLSTformat(false));
                }
            }
        }
        if (prereqs != null) {
            sb.append("|");
            sb.append(prereqs);
        }
        return sb;
    }
}

