/*
 * Decompiled with CFR 0.152.
 */
package pcgen.system;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.lang.ArrayUtils;
import pcgen.facade.util.AbstractListFacade;
import pcgen.system.ConfigurationSettings;
import pcgen.system.PCGenSettings;

final class RecentFileList
extends AbstractListFacade<File> {
    private static final int MAX_RECENT_FILES = 8;
    private final LinkedList<File> fileList = new LinkedList();
    private final String contextProp;

    public RecentFileList(String contextProp) {
        this.contextProp = contextProp;
        Object[] recentFiles = PCGenSettings.getInstance().getStringArray(contextProp);
        if (!ArrayUtils.isEmpty(recentFiles)) {
            URI userdir = new File(ConfigurationSettings.getUserDir()).toURI();
            for (int i = recentFiles.length - 1; i >= 0; --i) {
                this.addRecentFile(new File(userdir.resolve((String)recentFiles[i])));
            }
        }
    }

    private void updateRecentFileProp() {
        URI userdir = new File(ConfigurationSettings.getUserDir()).toURI();
        ArrayList<String> uris = new ArrayList<String>(this.fileList.size());
        for (File file : this.fileList) {
            URI uri = userdir.relativize(file.toURI());
            uris.add(uri.toString());
        }
        PCGenSettings.getInstance().setStringArray(this.contextProp, uris);
    }

    public void addRecentFile(File file) {
        File oldFile;
        if (file == null || !file.isFile()) {
            return;
        }
        int index = this.indexOf(file);
        if (index != -1) {
            oldFile = this.fileList.remove(index);
            this.fireElementRemoved(this, oldFile, index);
        }
        this.fileList.addFirst(file);
        this.fireElementAdded(this, file, 0);
        if (this.fileList.size() > 8) {
            oldFile = this.fileList.removeLast();
            this.fireElementRemoved(this, oldFile, 8);
        }
        this.updateRecentFileProp();
    }

    @Override
    public File getElementAt(int index) {
        return this.fileList.get(index);
    }

    @Override
    public int getSize() {
        return this.fileList.size();
    }

    @Override
    public boolean containsElement(File element) {
        return this.indexOf(element) != -1;
    }

    private int indexOf(File element) {
        if (element != null) {
            for (int i = 0; i < this.fileList.size(); ++i) {
                if (!this.fileList.get(i).getAbsolutePath().equals(element.getAbsolutePath())) continue;
                return i;
            }
        }
        return -1;
    }
}

