/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.cdom.enumeration.MapKey;
import pcgen.core.Race;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.MapChanges;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CrModToken
extends AbstractNonEmptyToken<Race>
implements CDOMPrimaryToken<Race> {
    @Override
    public String getTokenName() {
        return "CRMOD";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, Race race, String value) {
        int pipeLoc = value.indexOf("|");
        if (pipeLoc == -1) {
            return new ParseResult.Fail(this.getTokenName() + " expecting '|', format is: " + "ClassTypes|CRMod was: " + value, context);
        }
        if (pipeLoc != value.lastIndexOf("|")) {
            return new ParseResult.Fail(this.getTokenName() + " expecting only one '|', " + "format is: ClassTypes|CRMod was: " + value, context);
        }
        String keys = value.substring(0, pipeLoc);
        if (keys.length() == 0) {
            return new ParseResult.Fail(this.getTokenName() + " expecting non-empty class type, " + "format is: ClassTypes|CRMod was: " + value, context);
        }
        String val = value.substring(pipeLoc + 1);
        if (val.length() == 0) {
            return new ParseResult.Fail(this.getTokenName() + " expecting non-empty CR mod, " + "format is: ClassTypes|CRMod was: " + value, context);
        }
        try {
            StringTokenizer aTok = new StringTokenizer(keys, ".", false);
            while (aTok.hasMoreTokens()) {
                context.getObjectContext().put(race, MapKey.CRMOD, aTok.nextToken(), new Integer(val));
            }
        }
        catch (NumberFormatException e) {
            return new ParseResult.Fail(this.getTokenName() + " expecting number CR mod, " + "format is: ClassTypes|CRMod was: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Race race) {
        MapChanges<String, Integer> changes = context.getObjectContext().getMapChanges(race, MapKey.CRMOD);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        Map<String, Integer> added = changes.getAdded();
        for (Map.Entry<String, Integer> me : added.entrySet()) {
            set.add(me.getKey() + "|" + me.getValue());
        }
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Class<Race> getTokenClass() {
        return Race.class;
    }
}

