<?php
	// Project:    Web Reference Database (refbase) <http://www.refbase.net>
	// Copyright:  Matthias Steffens <mailto:refbase@extracts.de> and the file's
	//             original author(s).
	//
	//             This code is distributed in the hope that it will be useful,
	//             but WITHOUT ANY WARRANTY. Please see the GNU General Public
	//             License for more details.
	//
	// File:       ./import/import_scifinder2refbase.php
	// Repository: $HeadURL$
	// Author(s):  Matthias Steffens <mailto:refbase@extracts.de>
	//
	// Created:    17-Feb-07, 22:10
	// Modified:   $Date: 2007-02-18 12:41:15 +0000 (Sun, 18 Feb 2007) $
	//             $Author$
	//             $Revision: 895 $

	// This is an import format file (which must reside within the 'import/' sub-directory of your refbase root directory). It contains a version of the
	// 'importRecords()' function that imports records from 'SciFinder'-formatted data, i.e. data formatted according to the tagged text format used
	// by the commercial application 'SciFinder' (http://www.cas.org/SCIFINDER/).

	// --------------------------------------------------------------------

	// --- BEGIN IMPORT FORMAT ---

	// Import records from SciFinder-formatted source data:

	function importRecords($sourceText, $importRecordsRadio, $importRecordNumbersArray)
	{
		// parse SciFinder format:
		return scifinderToRefbase($sourceText, $importRecordsRadio, $importRecordNumbersArray); // function 'scifinderToRefbase()' is defined in 'import.inc.php'
	}

	// --- END IMPORT FORMAT ---

	// --------------------------------------------------------------------
?>
