/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.typing.Type;

public class DefaultLocalizationContext
implements LocalizationContext,
Serializable {
    private static final String CONFIG_TIMEZONE_KEY = "org.pentaho.reporting.libraries.formula.timezone";
    private static final String CONFIG_LOCALE_KEY = "org.pentaho.reporting.libraries.formula.locale";
    private static final String CONFIG_DATEFORMAT_KEY = "org.pentaho.reporting.libraries.formula.dateformat.";
    private ArrayList dateFormats = new ArrayList();
    private ArrayList datetimeFormats = new ArrayList();
    private ArrayList timeFormats = new ArrayList();
    private Locale locale;
    private TimeZone timeZone;

    public Locale getLocale() {
        return this.locale;
    }

    public ResourceBundle getBundle(String id) {
        return ResourceBundle.getBundle(id, this.getLocale());
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public List getDateFormats(Type type) {
        if (type.isFlagSet("type.date")) {
            return (List)this.dateFormats.clone();
        }
        if (type.isFlagSet("type.datetime")) {
            return (List)this.datetimeFormats.clone();
        }
        if (type.isFlagSet("type.time")) {
            return (List)this.timeFormats.clone();
        }
        return Collections.EMPTY_LIST;
    }

    private String[] createLocale(String locale) {
        StringTokenizer strtok = new StringTokenizer(locale, "_");
        String[] retval = new String[]{strtok.hasMoreElements() ? strtok.nextToken() : "", strtok.hasMoreElements() ? strtok.nextToken() : "", strtok.hasMoreElements() ? strtok.nextToken() : ""};
        return retval;
    }

    public void initialize(Configuration config) {
        this.initialize(config, null, null);
    }

    public void initialize(Configuration config, Locale locale, TimeZone timeZone) {
        DateFormat dateFormat;
        int i;
        if (config == null) {
            throw new NullPointerException();
        }
        if (locale == null) {
            String declaredLocale = config.getConfigProperty(CONFIG_LOCALE_KEY, Locale.getDefault().toString());
            String[] declaredLocaleParts = this.createLocale(declaredLocale);
            this.locale = new Locale(declaredLocaleParts[0], declaredLocaleParts[1], declaredLocaleParts[2]);
        } else {
            this.locale = locale;
        }
        if (timeZone == null) {
            String timeZoneId = config.getConfigProperty(CONFIG_TIMEZONE_KEY, TimeZone.getDefault().getID());
            this.timeZone = TimeZone.getTimeZone(timeZoneId);
        } else {
            this.timeZone = TimeZone.getDefault();
        }
        Locale activeLocale = this.getLocale();
        this.datetimeFormats.add(DateFormat.getDateTimeInstance(0, 0, activeLocale));
        this.dateFormats.add(DateFormat.getDateInstance(0, activeLocale));
        this.timeFormats.add(DateFormat.getTimeInstance(0, activeLocale));
        this.datetimeFormats.add(DateFormat.getDateTimeInstance(1, 1, activeLocale));
        this.dateFormats.add(DateFormat.getDateInstance(1, activeLocale));
        this.timeFormats.add(DateFormat.getTimeInstance(1, activeLocale));
        this.datetimeFormats.add(DateFormat.getDateTimeInstance(2, 2, activeLocale));
        this.dateFormats.add(DateFormat.getDateInstance(2, activeLocale));
        this.timeFormats.add(DateFormat.getTimeInstance(2, activeLocale));
        this.datetimeFormats.add(DateFormat.getDateTimeInstance(3, 3, activeLocale));
        this.dateFormats.add(DateFormat.getDateInstance(3, activeLocale));
        this.timeFormats.add(DateFormat.getTimeInstance(3, activeLocale));
        this.datetimeFormats.add(DateFormat.getDateTimeInstance(3, 3, activeLocale));
        this.dateFormats.add(DateFormat.getDateInstance(3, activeLocale));
        this.timeFormats.add(DateFormat.getTimeInstance(3, activeLocale));
        this.datetimeFormats.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US));
        this.datetimeFormats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US));
        this.dateFormats.add(new SimpleDateFormat("yyyy-MM-dd", Locale.US));
        this.timeFormats.add(new SimpleDateFormat("HH:mm:ss", Locale.US));
        this.timeFormats.add(new SimpleDateFormat("HH:mm", Locale.US));
        for (i = 0; i < this.dateFormats.size(); ++i) {
            dateFormat = (DateFormat)this.dateFormats.get(i);
            dateFormat.setLenient(false);
        }
        for (i = 0; i < this.datetimeFormats.size(); ++i) {
            dateFormat = (DateFormat)this.datetimeFormats.get(i);
            dateFormat.setLenient(false);
        }
        for (i = 0; i < this.timeFormats.size(); ++i) {
            dateFormat = (DateFormat)this.timeFormats.get(i);
            dateFormat.setLenient(false);
        }
    }
}

