/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic1.g1;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic1.Crossover;
import com.sun.electric.tool.placement.genetic1.GenePlacement;
import com.sun.electric.tool.placement.genetic1.Metric;
import com.sun.electric.tool.placement.genetic1.Population;
import com.sun.electric.tool.placement.genetic1.PopulationMutation;
import com.sun.electric.tool.placement.genetic1.Selection;
import com.sun.electric.tool.placement.genetic1.g1.CycleCrossoverFavoringStrongParents;
import com.sun.electric.tool.placement.genetic1.g1.GenePlacementLeftRightAlignedDrop;
import com.sun.electric.tool.placement.genetic1.g1.GeneticPlacement;
import com.sun.electric.tool.placement.genetic1.g1.MetricBoundingBox3;
import com.sun.electric.tool.placement.genetic1.g1.PlacementNodeProxy;
import com.sun.electric.tool.placement.genetic1.g1.PopulationMutation2;
import com.sun.electric.tool.placement.genetic1.g1.SelectionTournament;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;

public class SubPopulationProcessing
implements Callable<Population> {
    static int idcounter = 0;
    int id;
    Random randomGenerator;
    Population subPopulation;
    GenePlacement placement;
    Metric metric;
    Crossover crossover;
    PopulationMutation mutation;
    Selection selection;
    int epochLenght;

    public SubPopulationProcessing(int epochLenght, long randomSeed, int placementWidth, PlacementNodeProxy[] nodeProxies, List<PlacementFrame.PlacementNetwork> networks, int chromosomeSize) {
        this.epochLenght = epochLenght;
        this.randomGenerator = new Random(randomSeed);
        this.placement = new GenePlacementLeftRightAlignedDrop(placementWidth, chromosomeSize, nodeProxies);
        this.metric = new MetricBoundingBox3(networks, nodeProxies);
        this.crossover = new CycleCrossoverFavoringStrongParents(0.7f, this.randomGenerator, chromosomeSize);
        this.mutation = new PopulationMutation2(chromosomeSize);
        this.selection = new SelectionTournament();
        this.id = idcounter++;
    }

    @Override
    public Population call() throws Exception {
        this.subPopulation.evaluate(this.metric, this.placement);
        this.subPopulation.setRandomGenerator(this.randomGenerator);
        for (int threadGeneration = 0; threadGeneration < this.epochLenght && System.currentTimeMillis() <= GeneticPlacement.MAX_RUNTIME; ++threadGeneration) {
            GeneticPlacement.logger.debug("Thread Generation : {}", (Object)threadGeneration);
            GeneticPlacement.logger.debug("Task " + this.id + ":Start crossover in generation :" + threadGeneration);
            this.crossover.crossover(this.subPopulation);
            GeneticPlacement.logger.debug("Task " + this.id + ":Done crossover in generation :" + threadGeneration);
            GeneticPlacement.logger.debug("Task " + this.id + ":Start mutation in generation :" + threadGeneration);
            this.mutation.mutate(this.subPopulation);
            GeneticPlacement.logger.debug("Task " + this.id + ":Done mutation in generation :" + threadGeneration);
            GeneticPlacement.logger.debug("Task " + this.id + ":Start evaluating subpopulation in generation :" + threadGeneration);
            this.subPopulation.evaluate(this.metric, this.placement);
            GeneticPlacement.logger.debug("Task " + this.id + ":Done evaluating subpopulation in generation :" + threadGeneration);
            GeneticPlacement.logger.debug(threadGeneration + " Generation best fitness" + this.subPopulation.getBest_fitness());
            GeneticPlacement.logger.debug("Task " + this.id + ":Start selection in generation :" + threadGeneration);
            this.selection.selection(this.subPopulation);
            GeneticPlacement.logger.debug("Task " + this.id + ":Done selection in generation :" + threadGeneration);
        }
        return this.subPopulation;
    }

    void logProgress(int threadGeneration) {
        GeneticPlacement.PROGRESS_LOGGER.println((System.currentTimeMillis() - GeneticPlacement.START_TIME) / 1000L + ";" + this.id + ";" + threadGeneration + ";" + this.subPopulation.getBest_fitness() + ";" + this.subPopulation.chromosomes.size() + ";" + GeneticPlacement.current_population_size_per_thread + ";" + PopulationMutation2.chromosomeAlterPaddingRate + ";" + PopulationMutation2.genePaddingChangeRate_current + ";" + PopulationMutation2.chrosomeMaxPaddingChangeStep + ";" + PopulationMutation2.chromosomeMoveRate + ";" + PopulationMutation2.geneMoveRate_current + ";" + PopulationMutation2.geneMoveDistance + ";" + PopulationMutation2.chromosomeSwapRate + ";" + PopulationMutation2.geneSwapRate_current + ";" + PopulationMutation2.chromsomeRotationRate + ";" + "NA");
    }

    public void setSubPolulation(Population population) {
        this.subPopulation = population;
    }
}

